/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cat;

import co.elastic.clients.elasticsearch._types.Bytes;
import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch._types.TimeUnit;
import co.elastic.clients.elasticsearch.cat.CatRequestBase;
import co.elastic.clients.elasticsearch.cat.NodesResponse;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class NodesRequest
extends CatRequestBase {
    @Nullable
    private final Bytes bytes;
    @Nullable
    private final Boolean fullId;
    private final List<String> h;
    @Nullable
    private final Boolean includeUnloadedSegments;
    @Nullable
    private final Time masterTimeout;
    private final List<String> s;
    @Nullable
    private final TimeUnit time;
    public static final Endpoint<NodesRequest, NodesResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<NodesRequest, NodesResponse>("es/cat.nodes", request -> "GET", request -> "/_cat/nodes", request -> Collections.emptyMap(), request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("format", "json");
        if (request.masterTimeout != null) {
            params.put("master_timeout", request.masterTimeout._toJsonString());
        }
        if (ApiTypeHelper.isDefined(request.s)) {
            params.put("s", request.s.stream().map(v -> v).collect(Collectors.joining(",")));
        }
        if (request.bytes != null) {
            params.put("bytes", request.bytes.jsonValue());
        }
        if (ApiTypeHelper.isDefined(request.h)) {
            params.put("h", request.h.stream().map(v -> v).collect(Collectors.joining(",")));
        }
        if (request.includeUnloadedSegments != null) {
            params.put("include_unloaded_segments", String.valueOf(request.includeUnloadedSegments));
        }
        if (request.time != null) {
            params.put("time", request.time.jsonValue());
        }
        if (request.fullId != null) {
            params.put("full_id", String.valueOf(request.fullId));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, NodesResponse._DESERIALIZER);

    private NodesRequest(Builder builder) {
        this.bytes = builder.bytes;
        this.fullId = builder.fullId;
        this.h = ApiTypeHelper.unmodifiable(builder.h);
        this.includeUnloadedSegments = builder.includeUnloadedSegments;
        this.masterTimeout = builder.masterTimeout;
        this.s = ApiTypeHelper.unmodifiable(builder.s);
        this.time = builder.time;
    }

    public static NodesRequest of(Function<Builder, ObjectBuilder<NodesRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Bytes bytes() {
        return this.bytes;
    }

    @Nullable
    public final Boolean fullId() {
        return this.fullId;
    }

    public final List<String> h() {
        return this.h;
    }

    @Nullable
    public final Boolean includeUnloadedSegments() {
        return this.includeUnloadedSegments;
    }

    @Nullable
    public final Time masterTimeout() {
        return this.masterTimeout;
    }

    public final List<String> s() {
        return this.s;
    }

    @Nullable
    public final TimeUnit time() {
        return this.time;
    }

    public static class Builder
    extends CatRequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<NodesRequest> {
        @Nullable
        private Bytes bytes;
        @Nullable
        private Boolean fullId;
        @Nullable
        private List<String> h;
        @Nullable
        private Boolean includeUnloadedSegments;
        @Nullable
        private Time masterTimeout;
        @Nullable
        private List<String> s;
        @Nullable
        private TimeUnit time;

        public final Builder bytes(@Nullable Bytes value) {
            this.bytes = value;
            return this;
        }

        public final Builder fullId(@Nullable Boolean value) {
            this.fullId = value;
            return this;
        }

        public final Builder h(List<String> list) {
            this.h = Builder._listAddAll(this.h, list);
            return this;
        }

        public final Builder h(String value, String ... values) {
            this.h = Builder._listAdd(this.h, value, values);
            return this;
        }

        public final Builder includeUnloadedSegments(@Nullable Boolean value) {
            this.includeUnloadedSegments = value;
            return this;
        }

        public final Builder masterTimeout(@Nullable Time value) {
            this.masterTimeout = value;
            return this;
        }

        public final Builder masterTimeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.masterTimeout(fn.apply(new Time.Builder()).build());
        }

        public final Builder s(List<String> list) {
            this.s = Builder._listAddAll(this.s, list);
            return this;
        }

        public final Builder s(String value, String ... values) {
            this.s = Builder._listAdd(this.s, value, values);
            return this;
        }

        public final Builder time(@Nullable TimeUnit value) {
            this.time = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public NodesRequest build() {
            this._checkSingleUse();
            return new NodesRequest(this);
        }
    }
}

