/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.snapshot;

import co.elastic.clients.elasticsearch.snapshot.SnapshotInfo;
import co.elastic.clients.elasticsearch.snapshot.get.SnapshotResponseItem;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class GetSnapshotResponse
implements JsonpSerializable {
    private final int remaining;
    private final int total;
    @Nullable
    private final String next;
    private final List<SnapshotResponseItem> responses;
    private final List<SnapshotInfo> snapshots;
    public static final JsonpDeserializer<GetSnapshotResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GetSnapshotResponse::setupGetSnapshotResponseDeserializer);

    private GetSnapshotResponse(Builder builder) {
        this.remaining = ApiTypeHelper.requireNonNull(builder.remaining, this, "remaining");
        this.total = ApiTypeHelper.requireNonNull(builder.total, this, "total");
        this.next = builder.next;
        this.responses = ApiTypeHelper.unmodifiable(builder.responses);
        this.snapshots = ApiTypeHelper.unmodifiable(builder.snapshots);
    }

    public static GetSnapshotResponse of(Function<Builder, ObjectBuilder<GetSnapshotResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final int remaining() {
        return this.remaining;
    }

    public final int total() {
        return this.total;
    }

    @Nullable
    public final String next() {
        return this.next;
    }

    public final List<SnapshotResponseItem> responses() {
        return this.responses;
    }

    public final List<SnapshotInfo> snapshots() {
        return this.snapshots;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("remaining");
        generator.write(this.remaining);
        generator.writeKey("total");
        generator.write(this.total);
        if (this.next != null) {
            generator.writeKey("next");
            generator.write(this.next);
        }
        if (ApiTypeHelper.isDefined(this.responses)) {
            generator.writeKey("responses");
            generator.writeStartArray();
            for (SnapshotResponseItem snapshotResponseItem : this.responses) {
                snapshotResponseItem.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.snapshots)) {
            generator.writeKey("snapshots");
            generator.writeStartArray();
            for (SnapshotInfo snapshotInfo : this.snapshots) {
                snapshotInfo.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupGetSnapshotResponseDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::remaining, JsonpDeserializer.integerDeserializer(), "remaining");
        op.add(Builder::total, JsonpDeserializer.integerDeserializer(), "total");
        op.add(Builder::next, JsonpDeserializer.stringDeserializer(), "next");
        op.add(Builder::responses, JsonpDeserializer.arrayDeserializer(SnapshotResponseItem._DESERIALIZER), "responses");
        op.add(Builder::snapshots, JsonpDeserializer.arrayDeserializer(SnapshotInfo._DESERIALIZER), "snapshots");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<GetSnapshotResponse> {
        private Integer remaining;
        private Integer total;
        @Nullable
        private String next;
        @Nullable
        private List<SnapshotResponseItem> responses;
        @Nullable
        private List<SnapshotInfo> snapshots;

        public final Builder remaining(int value) {
            this.remaining = value;
            return this;
        }

        public final Builder total(int value) {
            this.total = value;
            return this;
        }

        public final Builder next(@Nullable String value) {
            this.next = value;
            return this;
        }

        public final Builder responses(List<SnapshotResponseItem> list) {
            this.responses = Builder._listAddAll(this.responses, list);
            return this;
        }

        public final Builder responses(SnapshotResponseItem value, SnapshotResponseItem ... values) {
            this.responses = Builder._listAdd(this.responses, value, values);
            return this;
        }

        public final Builder responses(Function<SnapshotResponseItem.Builder, ObjectBuilder<SnapshotResponseItem>> fn) {
            return this.responses(fn.apply(new SnapshotResponseItem.Builder()).build(), new SnapshotResponseItem[0]);
        }

        public final Builder snapshots(List<SnapshotInfo> list) {
            this.snapshots = Builder._listAddAll(this.snapshots, list);
            return this;
        }

        public final Builder snapshots(SnapshotInfo value, SnapshotInfo ... values) {
            this.snapshots = Builder._listAdd(this.snapshots, value, values);
            return this;
        }

        public final Builder snapshots(Function<SnapshotInfo.Builder, ObjectBuilder<SnapshotInfo>> fn) {
            return this.snapshots(fn.apply(new SnapshotInfo.Builder()).build(), new SnapshotInfo[0]);
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public GetSnapshotResponse build() {
            this._checkSingleUse();
            return new GetSnapshotResponse(this);
        }
    }
}

