/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.esql;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.FieldValue;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch.esql.EsqlFormat;
import co.elastic.clients.elasticsearch.esql.TableValues;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.BinaryEndpoint;
import co.elastic.clients.transport.endpoints.BinaryResponse;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class QueryRequest
extends RequestBase
implements JsonpSerializable {
    @Nullable
    private final Boolean columnar;
    @Nullable
    private final String delimiter;
    @Nullable
    private final Boolean dropNullColumns;
    @Nullable
    private final Query filter;
    @Nullable
    private final EsqlFormat format;
    @Nullable
    private final String locale;
    private final List<FieldValue> params;
    @Nullable
    private final Boolean profile;
    private final String query;
    private final Map<String, Map<String, TableValues>> tables;
    public static final JsonpDeserializer<QueryRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, QueryRequest::setupQueryRequestDeserializer);
    public static final Endpoint<QueryRequest, BinaryResponse, ErrorResponse> _ENDPOINT = new BinaryEndpoint<QueryRequest>("es/esql.query", request -> "POST", request -> "/_query", request -> Collections.emptyMap(), request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.delimiter != null) {
            params.put("delimiter", request.delimiter);
        }
        if (request.format != null) {
            params.put("format", request.format.jsonValue());
        }
        if (request.dropNullColumns != null) {
            params.put("drop_null_columns", String.valueOf(request.dropNullColumns));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, null);

    private QueryRequest(Builder builder) {
        this.columnar = builder.columnar;
        this.delimiter = builder.delimiter;
        this.dropNullColumns = builder.dropNullColumns;
        this.filter = builder.filter;
        this.format = builder.format;
        this.locale = builder.locale;
        this.params = ApiTypeHelper.unmodifiable(builder.params);
        this.profile = builder.profile;
        this.query = ApiTypeHelper.requireNonNull(builder.query, this, "query");
        this.tables = ApiTypeHelper.unmodifiable(builder.tables);
    }

    public static QueryRequest of(Function<Builder, ObjectBuilder<QueryRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Boolean columnar() {
        return this.columnar;
    }

    @Nullable
    public final String delimiter() {
        return this.delimiter;
    }

    @Nullable
    public final Boolean dropNullColumns() {
        return this.dropNullColumns;
    }

    @Nullable
    public final Query filter() {
        return this.filter;
    }

    @Nullable
    public final EsqlFormat format() {
        return this.format;
    }

    @Nullable
    public final String locale() {
        return this.locale;
    }

    public final List<FieldValue> params() {
        return this.params;
    }

    @Nullable
    public final Boolean profile() {
        return this.profile;
    }

    public final String query() {
        return this.query;
    }

    public final Map<String, Map<String, TableValues>> tables() {
        return this.tables;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.columnar != null) {
            generator.writeKey("columnar");
            generator.write(this.columnar.booleanValue());
        }
        if (this.filter != null) {
            generator.writeKey("filter");
            this.filter.serialize(generator, mapper);
        }
        if (this.locale != null) {
            generator.writeKey("locale");
            generator.write(this.locale);
        }
        if (ApiTypeHelper.isDefined(this.params)) {
            generator.writeKey("params");
            generator.writeStartArray();
            for (FieldValue fieldValue : this.params) {
                fieldValue.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.profile != null) {
            generator.writeKey("profile");
            generator.write(this.profile.booleanValue());
        }
        generator.writeKey("query");
        generator.write(this.query);
        if (ApiTypeHelper.isDefined(this.tables)) {
            generator.writeKey("tables");
            generator.writeStartObject();
            for (Map.Entry entry : this.tables.entrySet()) {
                generator.writeKey((String)entry.getKey());
                generator.writeStartObject();
                if (entry.getValue() != null) {
                    for (Map.Entry item1 : ((Map)entry.getValue()).entrySet()) {
                        generator.writeKey((String)item1.getKey());
                        ((TableValues)item1.getValue()).serialize(generator, mapper);
                    }
                }
                generator.writeEnd();
            }
            generator.writeEnd();
        }
    }

    protected static void setupQueryRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::columnar, JsonpDeserializer.booleanDeserializer(), "columnar");
        op.add(Builder::filter, Query._DESERIALIZER, "filter");
        op.add(Builder::locale, JsonpDeserializer.stringDeserializer(), "locale");
        op.add(Builder::params, JsonpDeserializer.arrayDeserializer(FieldValue._DESERIALIZER), "params");
        op.add(Builder::profile, JsonpDeserializer.booleanDeserializer(), "profile");
        op.add(Builder::query, JsonpDeserializer.stringDeserializer(), "query");
        op.add(Builder::tables, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.stringMapDeserializer(TableValues._DESERIALIZER)), "tables");
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<QueryRequest> {
        @Nullable
        private Boolean columnar;
        @Nullable
        private String delimiter;
        @Nullable
        private Boolean dropNullColumns;
        @Nullable
        private Query filter;
        @Nullable
        private EsqlFormat format;
        @Nullable
        private String locale;
        @Nullable
        private List<FieldValue> params;
        @Nullable
        private Boolean profile;
        private String query;
        @Nullable
        private Map<String, Map<String, TableValues>> tables;

        public final Builder columnar(@Nullable Boolean value) {
            this.columnar = value;
            return this;
        }

        public final Builder delimiter(@Nullable String value) {
            this.delimiter = value;
            return this;
        }

        public final Builder dropNullColumns(@Nullable Boolean value) {
            this.dropNullColumns = value;
            return this;
        }

        public final Builder filter(@Nullable Query value) {
            this.filter = value;
            return this;
        }

        public final Builder filter(Function<Query.Builder, ObjectBuilder<Query>> fn) {
            return this.filter(fn.apply(new Query.Builder()).build());
        }

        public final Builder format(@Nullable EsqlFormat value) {
            this.format = value;
            return this;
        }

        public final Builder locale(@Nullable String value) {
            this.locale = value;
            return this;
        }

        public final Builder params(List<FieldValue> list) {
            this.params = Builder._listAddAll(this.params, list);
            return this;
        }

        public final Builder params(FieldValue value, FieldValue ... values) {
            this.params = Builder._listAdd(this.params, value, values);
            return this;
        }

        public final Builder params(String value, String ... values) {
            this.params = Builder._listAdd(this.params, FieldValue.of(value), new FieldValue[0]);
            ArrayList<FieldValue> fieldValues = new ArrayList<FieldValue>();
            for (String v : values) {
                fieldValues.add(FieldValue.of(v));
            }
            this.params = Builder._listAddAll(this.params, fieldValues);
            return this;
        }

        public final Builder params(long value, long ... values) {
            this.params = Builder._listAdd(this.params, FieldValue.of(value), new FieldValue[0]);
            ArrayList<FieldValue> fieldValues = new ArrayList<FieldValue>();
            for (long v : values) {
                fieldValues.add(FieldValue.of(v));
            }
            this.params = Builder._listAddAll(this.params, fieldValues);
            return this;
        }

        public final Builder params(double value, double ... values) {
            this.params = Builder._listAdd(this.params, FieldValue.of(value), new FieldValue[0]);
            ArrayList<FieldValue> fieldValues = new ArrayList<FieldValue>();
            for (double v : values) {
                fieldValues.add(FieldValue.of(v));
            }
            this.params = Builder._listAddAll(this.params, fieldValues);
            return this;
        }

        public final Builder params(boolean value, boolean ... values) {
            this.params = Builder._listAdd(this.params, FieldValue.of(value), new FieldValue[0]);
            ArrayList<FieldValue> fieldValues = new ArrayList<FieldValue>();
            for (boolean v : values) {
                fieldValues.add(FieldValue.of(v));
            }
            this.params = Builder._listAddAll(this.params, fieldValues);
            return this;
        }

        public final Builder params(Function<FieldValue.Builder, ObjectBuilder<FieldValue>> fn) {
            return this.params(fn.apply(new FieldValue.Builder()).build(), new FieldValue[0]);
        }

        public final Builder profile(@Nullable Boolean value) {
            this.profile = value;
            return this;
        }

        public final Builder query(String value) {
            this.query = value;
            return this;
        }

        public final Builder tables(Map<String, Map<String, TableValues>> map) {
            this.tables = Builder._mapPutAll(this.tables, map);
            return this;
        }

        public final Builder tables(String key, Map<String, TableValues> value) {
            this.tables = Builder._mapPut(this.tables, key, value);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public QueryRequest build() {
            this._checkSingleUse();
            return new QueryRequest(this);
        }
    }
}

