/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.search_application;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.search_application.SearchApplicationSearchResponse;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class SearchApplicationSearchRequest
extends RequestBase
implements JsonpSerializable {
    private final String name;
    private final Map<String, JsonData> params;
    public static final JsonpDeserializer<SearchApplicationSearchRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SearchApplicationSearchRequest::setupSearchApplicationSearchRequestDeserializer);
    public static final SimpleEndpoint<SearchApplicationSearchRequest, ?> _ENDPOINT = new SimpleEndpoint<SearchApplicationSearchRequest, SearchApplicationSearchResponse<Object>>("es/search_application.search", request -> "POST", request -> {
        boolean _name = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_application");
            buf.append("/search_application");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.name, buf);
            buf.append("/_search");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), true, SearchApplicationSearchResponse._DESERIALIZER);

    private SearchApplicationSearchRequest(Builder builder) {
        this.name = ApiTypeHelper.requireNonNull(builder.name, this, "name");
        this.params = ApiTypeHelper.unmodifiable(builder.params);
    }

    public static SearchApplicationSearchRequest of(Function<Builder, ObjectBuilder<SearchApplicationSearchRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String name() {
        return this.name;
    }

    public final Map<String, JsonData> params() {
        return this.params;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.params)) {
            generator.writeKey("params");
            generator.writeStartObject();
            for (Map.Entry<String, JsonData> item0 : this.params.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static void setupSearchApplicationSearchRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::params, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "params");
    }

    public static <TDocument> Endpoint<SearchApplicationSearchRequest, SearchApplicationSearchResponse<TDocument>, ErrorResponse> createSearchEndpoint(JsonpDeserializer<TDocument> tDocumentDeserializer) {
        return _ENDPOINT.withResponseDeserializer(SearchApplicationSearchResponse.createSearchApplicationSearchResponseDeserializer(tDocumentDeserializer));
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<SearchApplicationSearchRequest> {
        private String name;
        @Nullable
        private Map<String, JsonData> params;

        public final Builder name(String value) {
            this.name = value;
            return this;
        }

        public final Builder params(Map<String, JsonData> map) {
            this.params = Builder._mapPutAll(this.params, map);
            return this;
        }

        public final Builder params(String key, JsonData value) {
            this.params = Builder._mapPut(this.params, key, value);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public SearchApplicationSearchRequest build() {
            this._checkSingleUse();
            return new SearchApplicationSearchRequest(this);
        }
    }
}

