/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.ml.DatafeedConfig;
import co.elastic.clients.elasticsearch.ml.JobConfig;
import co.elastic.clients.elasticsearch.ml.PreviewDatafeedResponse;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.DateTime;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class PreviewDatafeedRequest
extends RequestBase
implements JsonpSerializable {
    @Nullable
    private final DatafeedConfig datafeedConfig;
    @Nullable
    private final String datafeedId;
    @Nullable
    private final DateTime end;
    @Nullable
    private final JobConfig jobConfig;
    @Nullable
    private final DateTime start;
    public static final JsonpDeserializer<PreviewDatafeedRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PreviewDatafeedRequest::setupPreviewDatafeedRequestDeserializer);
    public static final SimpleEndpoint<PreviewDatafeedRequest, ?> _ENDPOINT = new SimpleEndpoint<PreviewDatafeedRequest, PreviewDatafeedResponse<Object>>("es/ml.preview_datafeed", request -> "POST", request -> {
        boolean _datafeedId = true;
        boolean propsSet = false;
        if (request.datafeedId() != null) {
            propsSet |= true;
        }
        if (propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_ml");
            buf.append("/datafeeds");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.datafeedId, buf);
            buf.append("/_preview");
            return buf.toString();
        }
        if (!propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_ml");
            buf.append("/datafeeds");
            buf.append("/_preview");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.start != null) {
            params.put("start", request.start.toString());
        }
        if (request.end != null) {
            params.put("end", request.end.toString());
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, PreviewDatafeedResponse._DESERIALIZER);

    private PreviewDatafeedRequest(Builder builder) {
        this.datafeedConfig = builder.datafeedConfig;
        this.datafeedId = builder.datafeedId;
        this.end = builder.end;
        this.jobConfig = builder.jobConfig;
        this.start = builder.start;
    }

    public static PreviewDatafeedRequest of(Function<Builder, ObjectBuilder<PreviewDatafeedRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final DatafeedConfig datafeedConfig() {
        return this.datafeedConfig;
    }

    @Nullable
    public final String datafeedId() {
        return this.datafeedId;
    }

    @Nullable
    public final DateTime end() {
        return this.end;
    }

    @Nullable
    public final JobConfig jobConfig() {
        return this.jobConfig;
    }

    @Nullable
    public final DateTime start() {
        return this.start;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.datafeedConfig != null) {
            generator.writeKey("datafeed_config");
            this.datafeedConfig.serialize(generator, mapper);
        }
        if (this.jobConfig != null) {
            generator.writeKey("job_config");
            this.jobConfig.serialize(generator, mapper);
        }
    }

    protected static void setupPreviewDatafeedRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::datafeedConfig, DatafeedConfig._DESERIALIZER, "datafeed_config");
        op.add(Builder::jobConfig, JobConfig._DESERIALIZER, "job_config");
    }

    public static <TDocument> Endpoint<PreviewDatafeedRequest, PreviewDatafeedResponse<TDocument>, ErrorResponse> createPreviewDatafeedEndpoint(JsonpDeserializer<TDocument> tDocumentDeserializer) {
        return _ENDPOINT.withResponseDeserializer(PreviewDatafeedResponse.createPreviewDatafeedResponseDeserializer(tDocumentDeserializer));
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<PreviewDatafeedRequest> {
        @Nullable
        private DatafeedConfig datafeedConfig;
        @Nullable
        private String datafeedId;
        @Nullable
        private DateTime end;
        @Nullable
        private JobConfig jobConfig;
        @Nullable
        private DateTime start;

        public final Builder datafeedConfig(@Nullable DatafeedConfig value) {
            this.datafeedConfig = value;
            return this;
        }

        public final Builder datafeedConfig(Function<DatafeedConfig.Builder, ObjectBuilder<DatafeedConfig>> fn) {
            return this.datafeedConfig(fn.apply(new DatafeedConfig.Builder()).build());
        }

        public final Builder datafeedId(@Nullable String value) {
            this.datafeedId = value;
            return this;
        }

        public final Builder end(@Nullable DateTime value) {
            this.end = value;
            return this;
        }

        public final Builder jobConfig(@Nullable JobConfig value) {
            this.jobConfig = value;
            return this;
        }

        public final Builder jobConfig(Function<JobConfig.Builder, ObjectBuilder<JobConfig>> fn) {
            return this.jobConfig(fn.apply(new JobConfig.Builder()).build());
        }

        public final Builder start(@Nullable DateTime value) {
            this.start = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public PreviewDatafeedRequest build() {
            this._checkSingleUse();
            return new PreviewDatafeedRequest(this);
        }
    }
}

