/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices;

import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch.indices.DlmRolloverConditions;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class DataLifecycleWithRollover
implements JsonpSerializable {
    @Nullable
    private final Time dataRetention;
    @Nullable
    private final DlmRolloverConditions rollover;
    public static final JsonpDeserializer<DataLifecycleWithRollover> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DataLifecycleWithRollover::setupDataLifecycleWithRolloverDeserializer);

    private DataLifecycleWithRollover(Builder builder) {
        this.dataRetention = builder.dataRetention;
        this.rollover = builder.rollover;
    }

    public static DataLifecycleWithRollover of(Function<Builder, ObjectBuilder<DataLifecycleWithRollover>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Time dataRetention() {
        return this.dataRetention;
    }

    @Nullable
    public final DlmRolloverConditions rollover() {
        return this.rollover;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.dataRetention != null) {
            generator.writeKey("data_retention");
            this.dataRetention.serialize(generator, mapper);
        }
        if (this.rollover != null) {
            generator.writeKey("rollover");
            this.rollover.serialize(generator, mapper);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupDataLifecycleWithRolloverDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::dataRetention, Time._DESERIALIZER, "data_retention");
        op.add(Builder::rollover, DlmRolloverConditions._DESERIALIZER, "rollover");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<DataLifecycleWithRollover> {
        @Nullable
        private Time dataRetention;
        @Nullable
        private DlmRolloverConditions rollover;

        public final Builder dataRetention(@Nullable Time value) {
            this.dataRetention = value;
            return this;
        }

        public final Builder dataRetention(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.dataRetention(fn.apply(new Time.Builder()).build());
        }

        public final Builder rollover(@Nullable DlmRolloverConditions value) {
            this.rollover = value;
            return this;
        }

        public final Builder rollover(Function<DlmRolloverConditions.Builder, ObjectBuilder<DlmRolloverConditions>> fn) {
            return this.rollover(fn.apply(new DlmRolloverConditions.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public DataLifecycleWithRollover build() {
            this._checkSingleUse();
            return new DataLifecycleWithRollover(this);
        }
    }
}

