/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.monitoring;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch.core.bulk.BulkOperation;
import co.elastic.clients.elasticsearch.monitoring.BulkResponse;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.NdJsonpSerializable;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

public class BulkRequest
extends RequestBase
implements NdJsonpSerializable,
JsonpSerializable {
    private final Time interval;
    private final String systemApiVersion;
    private final String systemId;
    @Nullable
    private final String type;
    private final List<BulkOperation> operations;
    public static final Endpoint<BulkRequest, BulkResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<BulkRequest, BulkResponse>("es/monitoring.bulk", request -> "POST", request -> {
        boolean _type = true;
        boolean propsSet = false;
        if (request.type() != null) {
            propsSet |= true;
        }
        if (!propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_monitoring");
            buf.append("/bulk");
            return buf.toString();
        }
        if (propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_monitoring");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.type, buf);
            buf.append("/bulk");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("system_id", request.systemId);
        params.put("system_api_version", request.systemApiVersion);
        params.put("interval", request.interval._toJsonString());
        return params;
    }, SimpleEndpoint.emptyMap(), true, BulkResponse._DESERIALIZER);

    private BulkRequest(Builder builder) {
        this.interval = ApiTypeHelper.requireNonNull(builder.interval, this, "interval");
        this.systemApiVersion = ApiTypeHelper.requireNonNull(builder.systemApiVersion, this, "systemApiVersion");
        this.systemId = ApiTypeHelper.requireNonNull(builder.systemId, this, "systemId");
        this.type = builder.type;
        this.operations = ApiTypeHelper.unmodifiableRequired(builder.operations, (Object)this, "operations");
    }

    public static BulkRequest of(Function<Builder, ObjectBuilder<BulkRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Iterator<?> _serializables() {
        return this.operations.iterator();
    }

    public final Time interval() {
        return this.interval;
    }

    public final String systemApiVersion() {
        return this.systemApiVersion;
    }

    public final String systemId() {
        return this.systemId;
    }

    @Deprecated
    @Nullable
    public final String type() {
        return this.type;
    }

    public final List<BulkOperation> operations() {
        return this.operations;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartArray();
        for (BulkOperation item0 : this.operations) {
            item0.serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<BulkRequest> {
        private Time interval;
        private String systemApiVersion;
        private String systemId;
        @Nullable
        private String type;
        private List<BulkOperation> operations;

        public final Builder interval(Time value) {
            this.interval = value;
            return this;
        }

        public final Builder interval(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.interval(fn.apply(new Time.Builder()).build());
        }

        public final Builder systemApiVersion(String value) {
            this.systemApiVersion = value;
            return this;
        }

        public final Builder systemId(String value) {
            this.systemId = value;
            return this;
        }

        @Deprecated
        public final Builder type(@Nullable String value) {
            this.type = value;
            return this;
        }

        public final Builder operations(List<BulkOperation> list) {
            this.operations = Builder._listAddAll(this.operations, list);
            return this;
        }

        public final Builder operations(BulkOperation value, BulkOperation ... values) {
            this.operations = Builder._listAdd(this.operations, value, values);
            return this;
        }

        public final Builder operations(Function<BulkOperation.Builder, ObjectBuilder<BulkOperation>> fn) {
            return this.operations(fn.apply(new BulkOperation.Builder()).build(), new BulkOperation[0]);
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public BulkRequest build() {
            this._checkSingleUse();
            return new BulkRequest(this);
        }
    }
}

