/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices;

import co.elastic.clients.elasticsearch._types.HealthStatus;
import co.elastic.clients.elasticsearch.indices.DataStreamIndex;
import co.elastic.clients.elasticsearch.indices.DataStreamTimestampField;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class DataStream
implements JsonpSerializable {
    private final String name;
    private final DataStreamTimestampField timestampField;
    private final List<DataStreamIndex> indices;
    private final int generation;
    private final String template;
    private final boolean hidden;
    @Nullable
    private final Boolean replicated;
    @Nullable
    private final Boolean system;
    private final HealthStatus status;
    @Nullable
    private final String ilmPolicy;
    private final Map<String, JsonData> meta;
    @Nullable
    private final Boolean allowCustomRouting;
    public static final JsonpDeserializer<DataStream> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DataStream::setupDataStreamDeserializer);

    private DataStream(Builder builder) {
        this.name = ApiTypeHelper.requireNonNull(builder.name, this, "name");
        this.timestampField = ApiTypeHelper.requireNonNull(builder.timestampField, this, "timestampField");
        this.indices = ApiTypeHelper.unmodifiableRequired(builder.indices, (Object)this, "indices");
        this.generation = ApiTypeHelper.requireNonNull(builder.generation, this, "generation");
        this.template = ApiTypeHelper.requireNonNull(builder.template, this, "template");
        this.hidden = ApiTypeHelper.requireNonNull(builder.hidden, this, "hidden");
        this.replicated = builder.replicated;
        this.system = builder.system;
        this.status = ApiTypeHelper.requireNonNull(builder.status, this, "status");
        this.ilmPolicy = builder.ilmPolicy;
        this.meta = ApiTypeHelper.unmodifiable(builder.meta);
        this.allowCustomRouting = builder.allowCustomRouting;
    }

    public static DataStream of(Function<Builder, ObjectBuilder<DataStream>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String name() {
        return this.name;
    }

    public final DataStreamTimestampField timestampField() {
        return this.timestampField;
    }

    public final List<DataStreamIndex> indices() {
        return this.indices;
    }

    public final int generation() {
        return this.generation;
    }

    public final String template() {
        return this.template;
    }

    public final boolean hidden() {
        return this.hidden;
    }

    @Nullable
    public final Boolean replicated() {
        return this.replicated;
    }

    @Nullable
    public final Boolean system() {
        return this.system;
    }

    public final HealthStatus status() {
        return this.status;
    }

    @Nullable
    public final String ilmPolicy() {
        return this.ilmPolicy;
    }

    public final Map<String, JsonData> meta() {
        return this.meta;
    }

    @Nullable
    public final Boolean allowCustomRouting() {
        return this.allowCustomRouting;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("name");
        generator.write(this.name);
        generator.writeKey("timestamp_field");
        this.timestampField.serialize(generator, mapper);
        if (ApiTypeHelper.isDefined(this.indices)) {
            generator.writeKey("indices");
            generator.writeStartArray();
            for (DataStreamIndex dataStreamIndex : this.indices) {
                dataStreamIndex.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        generator.writeKey("generation");
        generator.write(this.generation);
        generator.writeKey("template");
        generator.write(this.template);
        generator.writeKey("hidden");
        generator.write(this.hidden);
        if (this.replicated != null) {
            generator.writeKey("replicated");
            generator.write(this.replicated.booleanValue());
        }
        if (this.system != null) {
            generator.writeKey("system");
            generator.write(this.system.booleanValue());
        }
        generator.writeKey("status");
        this.status.serialize(generator, mapper);
        if (this.ilmPolicy != null) {
            generator.writeKey("ilm_policy");
            generator.write(this.ilmPolicy);
        }
        if (ApiTypeHelper.isDefined(this.meta)) {
            generator.writeKey("_meta");
            generator.writeStartObject();
            for (Map.Entry entry : this.meta.entrySet()) {
                generator.writeKey((String)entry.getKey());
                ((JsonData)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.allowCustomRouting != null) {
            generator.writeKey("allow_custom_routing");
            generator.write(this.allowCustomRouting.booleanValue());
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupDataStreamDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::name, JsonpDeserializer.stringDeserializer(), "name");
        op.add(Builder::timestampField, DataStreamTimestampField._DESERIALIZER, "timestamp_field");
        op.add(Builder::indices, JsonpDeserializer.arrayDeserializer(DataStreamIndex._DESERIALIZER), "indices");
        op.add(Builder::generation, JsonpDeserializer.integerDeserializer(), "generation");
        op.add(Builder::template, JsonpDeserializer.stringDeserializer(), "template");
        op.add(Builder::hidden, JsonpDeserializer.booleanDeserializer(), "hidden");
        op.add(Builder::replicated, JsonpDeserializer.booleanDeserializer(), "replicated");
        op.add(Builder::system, JsonpDeserializer.booleanDeserializer(), "system");
        op.add(Builder::status, HealthStatus._DESERIALIZER, "status");
        op.add(Builder::ilmPolicy, JsonpDeserializer.stringDeserializer(), "ilm_policy");
        op.add(Builder::meta, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "_meta");
        op.add(Builder::allowCustomRouting, JsonpDeserializer.booleanDeserializer(), "allow_custom_routing");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<DataStream> {
        private String name;
        private DataStreamTimestampField timestampField;
        private List<DataStreamIndex> indices;
        private Integer generation;
        private String template;
        private Boolean hidden;
        @Nullable
        private Boolean replicated;
        @Nullable
        private Boolean system;
        private HealthStatus status;
        @Nullable
        private String ilmPolicy;
        @Nullable
        private Map<String, JsonData> meta;
        @Nullable
        private Boolean allowCustomRouting;

        public final Builder name(String value) {
            this.name = value;
            return this;
        }

        public final Builder timestampField(DataStreamTimestampField value) {
            this.timestampField = value;
            return this;
        }

        public final Builder timestampField(Function<DataStreamTimestampField.Builder, ObjectBuilder<DataStreamTimestampField>> fn) {
            return this.timestampField(fn.apply(new DataStreamTimestampField.Builder()).build());
        }

        public final Builder indices(List<DataStreamIndex> list) {
            this.indices = Builder._listAddAll(this.indices, list);
            return this;
        }

        public final Builder indices(DataStreamIndex value, DataStreamIndex ... values) {
            this.indices = Builder._listAdd(this.indices, value, values);
            return this;
        }

        public final Builder indices(Function<DataStreamIndex.Builder, ObjectBuilder<DataStreamIndex>> fn) {
            return this.indices(fn.apply(new DataStreamIndex.Builder()).build(), new DataStreamIndex[0]);
        }

        public final Builder generation(int value) {
            this.generation = value;
            return this;
        }

        public final Builder template(String value) {
            this.template = value;
            return this;
        }

        public final Builder hidden(boolean value) {
            this.hidden = value;
            return this;
        }

        public final Builder replicated(@Nullable Boolean value) {
            this.replicated = value;
            return this;
        }

        public final Builder system(@Nullable Boolean value) {
            this.system = value;
            return this;
        }

        public final Builder status(HealthStatus value) {
            this.status = value;
            return this;
        }

        public final Builder ilmPolicy(@Nullable String value) {
            this.ilmPolicy = value;
            return this;
        }

        public final Builder meta(Map<String, JsonData> map) {
            this.meta = Builder._mapPutAll(this.meta, map);
            return this;
        }

        public final Builder meta(String key, JsonData value) {
            this.meta = Builder._mapPut(this.meta, key, value);
            return this;
        }

        public final Builder allowCustomRouting(@Nullable Boolean value) {
            this.allowCustomRouting = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public DataStream build() {
            this._checkSingleUse();
            return new DataStream(this);
        }
    }
}

