/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.ml.PutTrainedModelVocabularyResponse;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class PutTrainedModelVocabularyRequest
extends RequestBase
implements JsonpSerializable {
    private final List<String> merges;
    private final String modelId;
    private final List<String> vocabulary;
    public static final JsonpDeserializer<PutTrainedModelVocabularyRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PutTrainedModelVocabularyRequest::setupPutTrainedModelVocabularyRequestDeserializer);
    public static final Endpoint<PutTrainedModelVocabularyRequest, PutTrainedModelVocabularyResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<PutTrainedModelVocabularyRequest, PutTrainedModelVocabularyResponse>("es/ml.put_trained_model_vocabulary", request -> "PUT", request -> {
        boolean _modelId = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_ml");
            buf.append("/trained_models");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.modelId, buf);
            buf.append("/vocabulary");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), true, PutTrainedModelVocabularyResponse._DESERIALIZER);

    private PutTrainedModelVocabularyRequest(Builder builder) {
        this.merges = ApiTypeHelper.unmodifiable(builder.merges);
        this.modelId = ApiTypeHelper.requireNonNull(builder.modelId, this, "modelId");
        this.vocabulary = ApiTypeHelper.unmodifiableRequired(builder.vocabulary, (Object)this, "vocabulary");
    }

    public static PutTrainedModelVocabularyRequest of(Function<Builder, ObjectBuilder<PutTrainedModelVocabularyRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<String> merges() {
        return this.merges;
    }

    public final String modelId() {
        return this.modelId;
    }

    public final List<String> vocabulary() {
        return this.vocabulary;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.merges)) {
            generator.writeKey("merges");
            generator.writeStartArray();
            for (String item0 : this.merges) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.vocabulary)) {
            generator.writeKey("vocabulary");
            generator.writeStartArray();
            for (String item0 : this.vocabulary) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
    }

    protected static void setupPutTrainedModelVocabularyRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::merges, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "merges");
        op.add(Builder::vocabulary, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "vocabulary");
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<PutTrainedModelVocabularyRequest> {
        @Nullable
        private List<String> merges;
        private String modelId;
        private List<String> vocabulary;

        public final Builder merges(List<String> list) {
            this.merges = Builder._listAddAll(this.merges, list);
            return this;
        }

        public final Builder merges(String value, String ... values) {
            this.merges = Builder._listAdd(this.merges, value, values);
            return this;
        }

        public final Builder modelId(String value) {
            this.modelId = value;
            return this;
        }

        public final Builder vocabulary(List<String> list) {
            this.vocabulary = Builder._listAddAll(this.vocabulary, list);
            return this;
        }

        public final Builder vocabulary(String value, String ... values) {
            this.vocabulary = Builder._listAdd(this.vocabulary, value, values);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public PutTrainedModelVocabularyRequest build() {
            this._checkSingleUse();
            return new PutTrainedModelVocabularyRequest(this);
        }
    }
}

