/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.security;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.Refresh;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch.security.CreateApiKeyResponse;
import co.elastic.clients.elasticsearch.security.RoleDescriptor;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class CreateApiKeyRequest
extends RequestBase
implements JsonpSerializable {
    @Nullable
    private final Time expiration;
    private final Map<String, JsonData> metadata;
    @Nullable
    private final String name;
    @Nullable
    private final Refresh refresh;
    private final Map<String, RoleDescriptor> roleDescriptors;
    public static final JsonpDeserializer<CreateApiKeyRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, CreateApiKeyRequest::setupCreateApiKeyRequestDeserializer);
    public static final Endpoint<CreateApiKeyRequest, CreateApiKeyResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<CreateApiKeyRequest, CreateApiKeyResponse>("es/security.create_api_key", request -> "PUT", request -> "/_security/api_key", request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.refresh != null) {
            params.put("refresh", request.refresh.jsonValue());
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, CreateApiKeyResponse._DESERIALIZER);

    private CreateApiKeyRequest(Builder builder) {
        this.expiration = builder.expiration;
        this.metadata = ApiTypeHelper.unmodifiable(builder.metadata);
        this.name = builder.name;
        this.refresh = builder.refresh;
        this.roleDescriptors = ApiTypeHelper.unmodifiable(builder.roleDescriptors);
    }

    public static CreateApiKeyRequest of(Function<Builder, ObjectBuilder<CreateApiKeyRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Time expiration() {
        return this.expiration;
    }

    public final Map<String, JsonData> metadata() {
        return this.metadata;
    }

    @Nullable
    public final String name() {
        return this.name;
    }

    @Nullable
    public final Refresh refresh() {
        return this.refresh;
    }

    public final Map<String, RoleDescriptor> roleDescriptors() {
        return this.roleDescriptors;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.expiration != null) {
            generator.writeKey("expiration");
            this.expiration.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.metadata)) {
            generator.writeKey("metadata");
            generator.writeStartObject();
            for (Map.Entry<String, JsonData> entry : this.metadata.entrySet()) {
                generator.writeKey(entry.getKey());
                entry.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.name != null) {
            generator.writeKey("name");
            generator.write(this.name);
        }
        if (ApiTypeHelper.isDefined(this.roleDescriptors)) {
            generator.writeKey("role_descriptors");
            generator.writeStartObject();
            for (Map.Entry<String, JsonpSerializable> entry : this.roleDescriptors.entrySet()) {
                generator.writeKey(entry.getKey());
                ((RoleDescriptor)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static void setupCreateApiKeyRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::expiration, Time._DESERIALIZER, "expiration");
        op.add(Builder::metadata, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "metadata");
        op.add(Builder::name, JsonpDeserializer.stringDeserializer(), "name");
        op.add(Builder::roleDescriptors, JsonpDeserializer.stringMapDeserializer(RoleDescriptor._DESERIALIZER), "role_descriptors");
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<CreateApiKeyRequest> {
        @Nullable
        private Time expiration;
        @Nullable
        private Map<String, JsonData> metadata;
        @Nullable
        private String name;
        @Nullable
        private Refresh refresh;
        @Nullable
        private Map<String, RoleDescriptor> roleDescriptors;

        public final Builder expiration(@Nullable Time value) {
            this.expiration = value;
            return this;
        }

        public final Builder expiration(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.expiration(fn.apply(new Time.Builder()).build());
        }

        public final Builder metadata(Map<String, JsonData> map) {
            this.metadata = Builder._mapPutAll(this.metadata, map);
            return this;
        }

        public final Builder metadata(String key, JsonData value) {
            this.metadata = Builder._mapPut(this.metadata, key, value);
            return this;
        }

        public final Builder name(@Nullable String value) {
            this.name = value;
            return this;
        }

        public final Builder refresh(@Nullable Refresh value) {
            this.refresh = value;
            return this;
        }

        public final Builder roleDescriptors(Map<String, RoleDescriptor> map) {
            this.roleDescriptors = Builder._mapPutAll(this.roleDescriptors, map);
            return this;
        }

        public final Builder roleDescriptors(String key, RoleDescriptor value) {
            this.roleDescriptors = Builder._mapPut(this.roleDescriptors, key, value);
            return this;
        }

        public final Builder roleDescriptors(String key, Function<RoleDescriptor.Builder, ObjectBuilder<RoleDescriptor>> fn) {
            return this.roleDescriptors(key, fn.apply(new RoleDescriptor.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public CreateApiKeyRequest build() {
            this._checkSingleUse();
            return new CreateApiKeyRequest(this);
        }
    }
}

