/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch.ml.DeploymentAllocationState;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class TrainedModelDeploymentAllocationStatus
implements JsonpSerializable {
    private final int allocationCount;
    private final DeploymentAllocationState state;
    private final int targetAllocationCount;
    public static final JsonpDeserializer<TrainedModelDeploymentAllocationStatus> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, TrainedModelDeploymentAllocationStatus::setupTrainedModelDeploymentAllocationStatusDeserializer);

    private TrainedModelDeploymentAllocationStatus(Builder builder) {
        this.allocationCount = ApiTypeHelper.requireNonNull(builder.allocationCount, this, "allocationCount");
        this.state = ApiTypeHelper.requireNonNull(builder.state, this, "state");
        this.targetAllocationCount = ApiTypeHelper.requireNonNull(builder.targetAllocationCount, this, "targetAllocationCount");
    }

    public static TrainedModelDeploymentAllocationStatus of(Function<Builder, ObjectBuilder<TrainedModelDeploymentAllocationStatus>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final int allocationCount() {
        return this.allocationCount;
    }

    public final DeploymentAllocationState state() {
        return this.state;
    }

    public final int targetAllocationCount() {
        return this.targetAllocationCount;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("allocation_count");
        generator.write(this.allocationCount);
        generator.writeKey("state");
        this.state.serialize(generator, mapper);
        generator.writeKey("target_allocation_count");
        generator.write(this.targetAllocationCount);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupTrainedModelDeploymentAllocationStatusDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::allocationCount, JsonpDeserializer.integerDeserializer(), "allocation_count");
        op.add(Builder::state, DeploymentAllocationState._DESERIALIZER, "state");
        op.add(Builder::targetAllocationCount, JsonpDeserializer.integerDeserializer(), "target_allocation_count");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<TrainedModelDeploymentAllocationStatus> {
        private Integer allocationCount;
        private DeploymentAllocationState state;
        private Integer targetAllocationCount;

        public final Builder allocationCount(int value) {
            this.allocationCount = value;
            return this;
        }

        public final Builder state(DeploymentAllocationState value) {
            this.state = value;
            return this;
        }

        public final Builder targetAllocationCount(int value) {
            this.targetAllocationCount = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public TrainedModelDeploymentAllocationStatus build() {
            this._checkSingleUse();
            return new TrainedModelDeploymentAllocationStatus(this);
        }
    }
}

