/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.shutdown;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.TimeUnit;
import co.elastic.clients.elasticsearch.shutdown.GetNodeResponse;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class GetNodeRequest
extends RequestBase {
    @Nullable
    private final TimeUnit masterTimeout;
    private final List<String> nodeId;
    @Nullable
    private final TimeUnit timeout;
    public static final Endpoint<GetNodeRequest, GetNodeResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<GetNodeRequest, GetNodeResponse>("es/shutdown.get_node", request -> "GET", request -> {
        boolean _nodeId = true;
        boolean propsSet = false;
        if (ApiTypeHelper.isDefined(request.nodeId())) {
            propsSet |= true;
        }
        if (!propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_nodes");
            buf.append("/shutdown");
            return buf.toString();
        }
        if (propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_nodes");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.nodeId.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            buf.append("/shutdown");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.masterTimeout != null) {
            params.put("master_timeout", request.masterTimeout.jsonValue());
        }
        if (request.timeout != null) {
            params.put("timeout", request.timeout.jsonValue());
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, GetNodeResponse._DESERIALIZER);

    private GetNodeRequest(Builder builder) {
        this.masterTimeout = builder.masterTimeout;
        this.nodeId = ApiTypeHelper.unmodifiable(builder.nodeId);
        this.timeout = builder.timeout;
    }

    public static GetNodeRequest of(Function<Builder, ObjectBuilder<GetNodeRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final TimeUnit masterTimeout() {
        return this.masterTimeout;
    }

    public final List<String> nodeId() {
        return this.nodeId;
    }

    @Nullable
    public final TimeUnit timeout() {
        return this.timeout;
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<GetNodeRequest> {
        @Nullable
        private TimeUnit masterTimeout;
        @Nullable
        private List<String> nodeId;
        @Nullable
        private TimeUnit timeout;

        public final Builder masterTimeout(@Nullable TimeUnit value) {
            this.masterTimeout = value;
            return this;
        }

        public final Builder nodeId(List<String> list) {
            this.nodeId = Builder._listAddAll(this.nodeId, list);
            return this;
        }

        public final Builder nodeId(String value, String ... values) {
            this.nodeId = Builder._listAdd(this.nodeId, value, values);
            return this;
        }

        public final Builder timeout(@Nullable TimeUnit value) {
            this.timeout = value;
            return this;
        }

        @Override
        public GetNodeRequest build() {
            this._checkSingleUse();
            return new GetNodeRequest(this);
        }
    }
}

