/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.ExpandWildcard;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.mapping.RuntimeField;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch.core.FieldCapsResponse;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

@JsonpDeserializable
public class FieldCapsRequest
extends RequestBase
implements JsonpSerializable {
    @Nullable
    private final Boolean allowNoIndices;
    private final List<ExpandWildcard> expandWildcards;
    private final List<String> fields;
    @Nullable
    private final String filters;
    @Nullable
    private final Boolean ignoreUnavailable;
    @Nullable
    private final Boolean includeUnmapped;
    private final List<String> index;
    @Nullable
    private final Query indexFilter;
    private final Map<String, RuntimeField> runtimeMappings;
    private final List<String> types;
    public static final JsonpDeserializer<FieldCapsRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, FieldCapsRequest::setupFieldCapsRequestDeserializer);
    public static final Endpoint<FieldCapsRequest, FieldCapsResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<FieldCapsRequest, FieldCapsResponse>("es/field_caps", request -> "POST", request -> {
        boolean _index = true;
        boolean propsSet = false;
        if (ApiTypeHelper.isDefined(request.index())) {
            propsSet |= true;
        }
        if (!propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_field_caps");
            return buf.toString();
        }
        if (propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/");
            SimpleEndpoint.pathEncode(request.index.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            buf.append("/_field_caps");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (ApiTypeHelper.isDefined(request.types)) {
            params.put("types", request.types.stream().map(v -> v).collect(Collectors.joining(",")));
        }
        if (ApiTypeHelper.isDefined(request.expandWildcards)) {
            params.put("expand_wildcards", request.expandWildcards.stream().map(v -> v.jsonValue()).collect(Collectors.joining(",")));
        }
        if (request.ignoreUnavailable != null) {
            params.put("ignore_unavailable", String.valueOf(request.ignoreUnavailable));
        }
        if (request.allowNoIndices != null) {
            params.put("allow_no_indices", String.valueOf(request.allowNoIndices));
        }
        if (request.filters != null) {
            params.put("filters", request.filters);
        }
        params.put("fields", request.fields.stream().map(v -> v).collect(Collectors.joining(",")));
        if (request.includeUnmapped != null) {
            params.put("include_unmapped", String.valueOf(request.includeUnmapped));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, FieldCapsResponse._DESERIALIZER);

    private FieldCapsRequest(Builder builder) {
        this.allowNoIndices = builder.allowNoIndices;
        this.expandWildcards = ApiTypeHelper.unmodifiable(builder.expandWildcards);
        this.fields = ApiTypeHelper.unmodifiableRequired(builder.fields, (Object)this, "fields");
        this.filters = builder.filters;
        this.ignoreUnavailable = builder.ignoreUnavailable;
        this.includeUnmapped = builder.includeUnmapped;
        this.index = ApiTypeHelper.unmodifiable(builder.index);
        this.indexFilter = builder.indexFilter;
        this.runtimeMappings = ApiTypeHelper.unmodifiable(builder.runtimeMappings);
        this.types = ApiTypeHelper.unmodifiable(builder.types);
    }

    public static FieldCapsRequest of(Function<Builder, ObjectBuilder<FieldCapsRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Boolean allowNoIndices() {
        return this.allowNoIndices;
    }

    public final List<ExpandWildcard> expandWildcards() {
        return this.expandWildcards;
    }

    public final List<String> fields() {
        return this.fields;
    }

    @Nullable
    public final String filters() {
        return this.filters;
    }

    @Nullable
    public final Boolean ignoreUnavailable() {
        return this.ignoreUnavailable;
    }

    @Nullable
    public final Boolean includeUnmapped() {
        return this.includeUnmapped;
    }

    public final List<String> index() {
        return this.index;
    }

    @Nullable
    public final Query indexFilter() {
        return this.indexFilter;
    }

    public final Map<String, RuntimeField> runtimeMappings() {
        return this.runtimeMappings;
    }

    public final List<String> types() {
        return this.types;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.indexFilter != null) {
            generator.writeKey("index_filter");
            this.indexFilter.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.runtimeMappings)) {
            generator.writeKey("runtime_mappings");
            generator.writeStartObject();
            for (Map.Entry<String, RuntimeField> item0 : this.runtimeMappings.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static void setupFieldCapsRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::indexFilter, Query._DESERIALIZER, "index_filter");
        op.add(Builder::runtimeMappings, JsonpDeserializer.stringMapDeserializer(RuntimeField._DESERIALIZER), "runtime_mappings");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<FieldCapsRequest> {
        @Nullable
        private Boolean allowNoIndices;
        @Nullable
        private List<ExpandWildcard> expandWildcards;
        private List<String> fields;
        @Nullable
        private String filters;
        @Nullable
        private Boolean ignoreUnavailable;
        @Nullable
        private Boolean includeUnmapped;
        @Nullable
        private List<String> index;
        @Nullable
        private Query indexFilter;
        @Nullable
        private Map<String, RuntimeField> runtimeMappings;
        @Nullable
        private List<String> types;

        public final Builder allowNoIndices(@Nullable Boolean value) {
            this.allowNoIndices = value;
            return this;
        }

        public final Builder expandWildcards(List<ExpandWildcard> list) {
            this.expandWildcards = Builder._listAddAll(this.expandWildcards, list);
            return this;
        }

        public final Builder expandWildcards(ExpandWildcard value, ExpandWildcard ... values) {
            this.expandWildcards = Builder._listAdd(this.expandWildcards, value, values);
            return this;
        }

        public final Builder fields(List<String> list) {
            this.fields = Builder._listAddAll(this.fields, list);
            return this;
        }

        public final Builder fields(String value, String ... values) {
            this.fields = Builder._listAdd(this.fields, value, values);
            return this;
        }

        public final Builder filters(@Nullable String value) {
            this.filters = value;
            return this;
        }

        public final Builder ignoreUnavailable(@Nullable Boolean value) {
            this.ignoreUnavailable = value;
            return this;
        }

        public final Builder includeUnmapped(@Nullable Boolean value) {
            this.includeUnmapped = value;
            return this;
        }

        public final Builder index(List<String> list) {
            this.index = Builder._listAddAll(this.index, list);
            return this;
        }

        public final Builder index(String value, String ... values) {
            this.index = Builder._listAdd(this.index, value, values);
            return this;
        }

        public final Builder indexFilter(@Nullable Query value) {
            this.indexFilter = value;
            return this;
        }

        public final Builder indexFilter(Function<Query.Builder, ObjectBuilder<Query>> fn) {
            return this.indexFilter(fn.apply(new Query.Builder()).build());
        }

        public final Builder runtimeMappings(Map<String, RuntimeField> map) {
            this.runtimeMappings = Builder._mapPutAll(this.runtimeMappings, map);
            return this;
        }

        public final Builder runtimeMappings(String key, RuntimeField value) {
            this.runtimeMappings = Builder._mapPut(this.runtimeMappings, key, value);
            return this;
        }

        public final Builder runtimeMappings(String key, Function<RuntimeField.Builder, ObjectBuilder<RuntimeField>> fn) {
            return this.runtimeMappings(key, fn.apply(new RuntimeField.Builder()).build());
        }

        public final Builder types(List<String> list) {
            this.types = Builder._listAddAll(this.types, list);
            return this;
        }

        public final Builder types(String value, String ... values) {
            this.types = Builder._listAdd(this.types, value, values);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public FieldCapsRequest build() {
            this._checkSingleUse();
            return new FieldCapsRequest(this);
        }
    }
}

