/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.shutdown;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.TimeUnit;
import co.elastic.clients.elasticsearch.shutdown.DeleteNodeResponse;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import java.util.HashMap;
import java.util.function.Function;
import javax.annotation.Nullable;

public class DeleteNodeRequest
extends RequestBase {
    @Nullable
    private final TimeUnit masterTimeout;
    private final String nodeId;
    @Nullable
    private final TimeUnit timeout;
    public static final Endpoint<DeleteNodeRequest, DeleteNodeResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<DeleteNodeRequest, DeleteNodeResponse>("es/shutdown.delete_node", request -> "DELETE", request -> {
        boolean _nodeId = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_nodes");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.nodeId, buf);
            buf.append("/shutdown");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.masterTimeout != null) {
            params.put("master_timeout", request.masterTimeout.jsonValue());
        }
        if (request.timeout != null) {
            params.put("timeout", request.timeout.jsonValue());
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, DeleteNodeResponse._DESERIALIZER);

    private DeleteNodeRequest(Builder builder) {
        this.masterTimeout = builder.masterTimeout;
        this.nodeId = ApiTypeHelper.requireNonNull(builder.nodeId, this, "nodeId");
        this.timeout = builder.timeout;
    }

    public static DeleteNodeRequest of(Function<Builder, ObjectBuilder<DeleteNodeRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final TimeUnit masterTimeout() {
        return this.masterTimeout;
    }

    public final String nodeId() {
        return this.nodeId;
    }

    @Nullable
    public final TimeUnit timeout() {
        return this.timeout;
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<DeleteNodeRequest> {
        @Nullable
        private TimeUnit masterTimeout;
        private String nodeId;
        @Nullable
        private TimeUnit timeout;

        public final Builder masterTimeout(@Nullable TimeUnit value) {
            this.masterTimeout = value;
            return this;
        }

        public final Builder nodeId(String value) {
            this.nodeId = value;
            return this;
        }

        public final Builder timeout(@Nullable TimeUnit value) {
            this.timeout = value;
            return this;
        }

        @Override
        public DeleteNodeRequest build() {
            this._checkSingleUse();
            return new DeleteNodeRequest(this);
        }
    }
}

