/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch.ml.DeploymentAllocationState;
import co.elastic.clients.elasticsearch.ml.StartTrainedModelDeploymentResponse;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import java.util.HashMap;
import java.util.function.Function;
import javax.annotation.Nullable;

public class StartTrainedModelDeploymentRequest
extends RequestBase {
    private final String modelId;
    @Nullable
    private final Integer numberOfAllocations;
    @Nullable
    private final Integer queueCapacity;
    @Nullable
    private final Integer threadsPerAllocation;
    @Nullable
    private final Time timeout;
    @Nullable
    private final DeploymentAllocationState waitFor;
    public static final Endpoint<StartTrainedModelDeploymentRequest, StartTrainedModelDeploymentResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<StartTrainedModelDeploymentRequest, StartTrainedModelDeploymentResponse>("es/ml.start_trained_model_deployment", request -> "POST", request -> {
        boolean _modelId = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_ml");
            buf.append("/trained_models");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.modelId, buf);
            buf.append("/deployment");
            buf.append("/_start");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.threadsPerAllocation != null) {
            params.put("threads_per_allocation", String.valueOf(request.threadsPerAllocation));
        }
        if (request.waitFor != null) {
            params.put("wait_for", request.waitFor.jsonValue());
        }
        if (request.numberOfAllocations != null) {
            params.put("number_of_allocations", String.valueOf(request.numberOfAllocations));
        }
        if (request.timeout != null) {
            params.put("timeout", request.timeout._toJsonString());
        }
        if (request.queueCapacity != null) {
            params.put("queue_capacity", String.valueOf(request.queueCapacity));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, StartTrainedModelDeploymentResponse._DESERIALIZER);

    private StartTrainedModelDeploymentRequest(Builder builder) {
        this.modelId = ApiTypeHelper.requireNonNull(builder.modelId, this, "modelId");
        this.numberOfAllocations = builder.numberOfAllocations;
        this.queueCapacity = builder.queueCapacity;
        this.threadsPerAllocation = builder.threadsPerAllocation;
        this.timeout = builder.timeout;
        this.waitFor = builder.waitFor;
    }

    public static StartTrainedModelDeploymentRequest of(Function<Builder, ObjectBuilder<StartTrainedModelDeploymentRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String modelId() {
        return this.modelId;
    }

    @Nullable
    public final Integer numberOfAllocations() {
        return this.numberOfAllocations;
    }

    @Nullable
    public final Integer queueCapacity() {
        return this.queueCapacity;
    }

    @Nullable
    public final Integer threadsPerAllocation() {
        return this.threadsPerAllocation;
    }

    @Nullable
    public final Time timeout() {
        return this.timeout;
    }

    @Nullable
    public final DeploymentAllocationState waitFor() {
        return this.waitFor;
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<StartTrainedModelDeploymentRequest> {
        private String modelId;
        @Nullable
        private Integer numberOfAllocations;
        @Nullable
        private Integer queueCapacity;
        @Nullable
        private Integer threadsPerAllocation;
        @Nullable
        private Time timeout;
        @Nullable
        private DeploymentAllocationState waitFor;

        public final Builder modelId(String value) {
            this.modelId = value;
            return this;
        }

        public final Builder numberOfAllocations(@Nullable Integer value) {
            this.numberOfAllocations = value;
            return this;
        }

        public final Builder queueCapacity(@Nullable Integer value) {
            this.queueCapacity = value;
            return this;
        }

        public final Builder threadsPerAllocation(@Nullable Integer value) {
            this.threadsPerAllocation = value;
            return this;
        }

        public final Builder timeout(@Nullable Time value) {
            this.timeout = value;
            return this;
        }

        public final Builder timeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.timeout(fn.apply(new Time.Builder()).build());
        }

        public final Builder waitFor(@Nullable DeploymentAllocationState value) {
            this.waitFor = value;
            return this;
        }

        @Override
        public StartTrainedModelDeploymentRequest build() {
            this._checkSingleUse();
            return new StartTrainedModelDeploymentRequest(this);
        }
    }
}

