/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch.ml.FillMaskInferenceUpdateOptions;
import co.elastic.clients.elasticsearch.ml.NerInferenceUpdateOptions;
import co.elastic.clients.elasticsearch.ml.NlpInferenceConfigUpdateVariant;
import co.elastic.clients.elasticsearch.ml.PassThroughInferenceUpdateOptions;
import co.elastic.clients.elasticsearch.ml.TextClassificationInferenceUpdateOptions;
import co.elastic.clients.elasticsearch.ml.TextEmbeddingInferenceUpdateOptions;
import co.elastic.clients.elasticsearch.ml.ZeroShotClassificationInferenceUpdateOptions;
import co.elastic.clients.json.JsonEnum;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.TaggedUnion;
import co.elastic.clients.util.TaggedUnionUtils;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class NlpInferenceConfigUpdate
implements TaggedUnion<Kind, Object>,
JsonpSerializable {
    private final Kind _kind;
    private final Object _value;
    public static final JsonpDeserializer<NlpInferenceConfigUpdate> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, NlpInferenceConfigUpdate::setupNlpInferenceConfigUpdateDeserializer, Builder::build);

    @Override
    public final Kind _kind() {
        return this._kind;
    }

    @Override
    public final Object _get() {
        return this._value;
    }

    public NlpInferenceConfigUpdate(NlpInferenceConfigUpdateVariant value) {
        this._kind = ApiTypeHelper.requireNonNull(value._nlpInferenceConfigUpdateKind(), this, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(value, this, "<variant value>");
    }

    private NlpInferenceConfigUpdate(Builder builder) {
        this._kind = ApiTypeHelper.requireNonNull(builder._kind, builder, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(builder._value, builder, "<variant value>");
    }

    public static NlpInferenceConfigUpdate of(Function<Builder, ObjectBuilder<NlpInferenceConfigUpdate>> fn) {
        return fn.apply(new Builder()).build();
    }

    public boolean isTextClassification() {
        return this._kind == Kind.TextClassification;
    }

    public TextClassificationInferenceUpdateOptions textClassification() {
        return (TextClassificationInferenceUpdateOptions)TaggedUnionUtils.get(this, Kind.TextClassification);
    }

    public boolean isZeroShotClassification() {
        return this._kind == Kind.ZeroShotClassification;
    }

    public ZeroShotClassificationInferenceUpdateOptions zeroShotClassification() {
        return (ZeroShotClassificationInferenceUpdateOptions)TaggedUnionUtils.get(this, Kind.ZeroShotClassification);
    }

    public boolean isFillMask() {
        return this._kind == Kind.FillMask;
    }

    public FillMaskInferenceUpdateOptions fillMask() {
        return (FillMaskInferenceUpdateOptions)TaggedUnionUtils.get(this, Kind.FillMask);
    }

    public boolean isNer() {
        return this._kind == Kind.Ner;
    }

    public NerInferenceUpdateOptions ner() {
        return (NerInferenceUpdateOptions)TaggedUnionUtils.get(this, Kind.Ner);
    }

    public boolean isPassThrough() {
        return this._kind == Kind.PassThrough;
    }

    public PassThroughInferenceUpdateOptions passThrough() {
        return (PassThroughInferenceUpdateOptions)TaggedUnionUtils.get(this, Kind.PassThrough);
    }

    public boolean isTextEmbedding() {
        return this._kind == Kind.TextEmbedding;
    }

    public TextEmbeddingInferenceUpdateOptions textEmbedding() {
        return (TextEmbeddingInferenceUpdateOptions)TaggedUnionUtils.get(this, Kind.TextEmbedding);
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        generator.writeKey(this._kind.jsonValue());
        if (this._value instanceof JsonpSerializable) {
            ((JsonpSerializable)this._value).serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    protected static void setupNlpInferenceConfigUpdateDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::textClassification, TextClassificationInferenceUpdateOptions._DESERIALIZER, "text_classification");
        op.add(Builder::zeroShotClassification, ZeroShotClassificationInferenceUpdateOptions._DESERIALIZER, "zero_shot_classification");
        op.add(Builder::fillMask, FillMaskInferenceUpdateOptions._DESERIALIZER, "fill_mask");
        op.add(Builder::ner, NerInferenceUpdateOptions._DESERIALIZER, "ner");
        op.add(Builder::passThrough, PassThroughInferenceUpdateOptions._DESERIALIZER, "pass_through");
        op.add(Builder::textEmbedding, TextEmbeddingInferenceUpdateOptions._DESERIALIZER, "text_embedding");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<NlpInferenceConfigUpdate> {
        private Kind _kind;
        private Object _value;

        @Override
        protected Builder self() {
            return this;
        }

        public ObjectBuilder<NlpInferenceConfigUpdate> textClassification(TextClassificationInferenceUpdateOptions v) {
            this._kind = Kind.TextClassification;
            this._value = v;
            return this;
        }

        public ObjectBuilder<NlpInferenceConfigUpdate> textClassification(Function<TextClassificationInferenceUpdateOptions.Builder, ObjectBuilder<TextClassificationInferenceUpdateOptions>> fn) {
            return this.textClassification(fn.apply(new TextClassificationInferenceUpdateOptions.Builder()).build());
        }

        public ObjectBuilder<NlpInferenceConfigUpdate> zeroShotClassification(ZeroShotClassificationInferenceUpdateOptions v) {
            this._kind = Kind.ZeroShotClassification;
            this._value = v;
            return this;
        }

        public ObjectBuilder<NlpInferenceConfigUpdate> zeroShotClassification(Function<ZeroShotClassificationInferenceUpdateOptions.Builder, ObjectBuilder<ZeroShotClassificationInferenceUpdateOptions>> fn) {
            return this.zeroShotClassification(fn.apply(new ZeroShotClassificationInferenceUpdateOptions.Builder()).build());
        }

        public ObjectBuilder<NlpInferenceConfigUpdate> fillMask(FillMaskInferenceUpdateOptions v) {
            this._kind = Kind.FillMask;
            this._value = v;
            return this;
        }

        public ObjectBuilder<NlpInferenceConfigUpdate> fillMask(Function<FillMaskInferenceUpdateOptions.Builder, ObjectBuilder<FillMaskInferenceUpdateOptions>> fn) {
            return this.fillMask(fn.apply(new FillMaskInferenceUpdateOptions.Builder()).build());
        }

        public ObjectBuilder<NlpInferenceConfigUpdate> ner(NerInferenceUpdateOptions v) {
            this._kind = Kind.Ner;
            this._value = v;
            return this;
        }

        public ObjectBuilder<NlpInferenceConfigUpdate> ner(Function<NerInferenceUpdateOptions.Builder, ObjectBuilder<NerInferenceUpdateOptions>> fn) {
            return this.ner(fn.apply(new NerInferenceUpdateOptions.Builder()).build());
        }

        public ObjectBuilder<NlpInferenceConfigUpdate> passThrough(PassThroughInferenceUpdateOptions v) {
            this._kind = Kind.PassThrough;
            this._value = v;
            return this;
        }

        public ObjectBuilder<NlpInferenceConfigUpdate> passThrough(Function<PassThroughInferenceUpdateOptions.Builder, ObjectBuilder<PassThroughInferenceUpdateOptions>> fn) {
            return this.passThrough(fn.apply(new PassThroughInferenceUpdateOptions.Builder()).build());
        }

        public ObjectBuilder<NlpInferenceConfigUpdate> textEmbedding(TextEmbeddingInferenceUpdateOptions v) {
            this._kind = Kind.TextEmbedding;
            this._value = v;
            return this;
        }

        public ObjectBuilder<NlpInferenceConfigUpdate> textEmbedding(Function<TextEmbeddingInferenceUpdateOptions.Builder, ObjectBuilder<TextEmbeddingInferenceUpdateOptions>> fn) {
            return this.textEmbedding(fn.apply(new TextEmbeddingInferenceUpdateOptions.Builder()).build());
        }

        @Override
        public NlpInferenceConfigUpdate build() {
            this._checkSingleUse();
            return new NlpInferenceConfigUpdate(this);
        }
    }

    public static enum Kind implements JsonEnum
    {
        TextClassification("text_classification"),
        ZeroShotClassification("zero_shot_classification"),
        FillMask("fill_mask"),
        Ner("ner"),
        PassThrough("pass_through"),
        TextEmbedding("text_embedding");

        private final String jsonValue;

        private Kind(String jsonValue) {
            this.jsonValue = jsonValue;
        }

        @Override
        public String jsonValue() {
            return this.jsonValue;
        }
    }
}

