/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.ml.GetDatafeedStatsResponse;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class GetDatafeedStatsRequest
extends RequestBase {
    @Nullable
    private final Boolean allowNoMatch;
    private final List<String> datafeedId;
    public static final Endpoint<GetDatafeedStatsRequest, GetDatafeedStatsResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<GetDatafeedStatsRequest, GetDatafeedStatsResponse>("es/ml.get_datafeed_stats", request -> "GET", request -> {
        boolean _datafeedId = true;
        boolean propsSet = false;
        if (ApiTypeHelper.isDefined(request.datafeedId())) {
            propsSet |= true;
        }
        if (propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_ml");
            buf.append("/datafeeds");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.datafeedId.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            buf.append("/_stats");
            return buf.toString();
        }
        if (!propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_ml");
            buf.append("/datafeeds");
            buf.append("/_stats");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.allowNoMatch != null) {
            params.put("allow_no_match", String.valueOf(request.allowNoMatch));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, GetDatafeedStatsResponse._DESERIALIZER);

    private GetDatafeedStatsRequest(Builder builder) {
        this.allowNoMatch = builder.allowNoMatch;
        this.datafeedId = ApiTypeHelper.unmodifiable(builder.datafeedId);
    }

    public static GetDatafeedStatsRequest of(Function<Builder, ObjectBuilder<GetDatafeedStatsRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Boolean allowNoMatch() {
        return this.allowNoMatch;
    }

    public final List<String> datafeedId() {
        return this.datafeedId;
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<GetDatafeedStatsRequest> {
        @Nullable
        private Boolean allowNoMatch;
        @Nullable
        private List<String> datafeedId;

        public final Builder allowNoMatch(@Nullable Boolean value) {
            this.allowNoMatch = value;
            return this;
        }

        public final Builder datafeedId(List<String> list) {
            this.datafeedId = Builder._listAddAll(this.datafeedId, list);
            return this;
        }

        public final Builder datafeedId(String value, String ... values) {
            this.datafeedId = Builder._listAdd(this.datafeedId, value, values);
            return this;
        }

        @Override
        public GetDatafeedStatsRequest build() {
            this._checkSingleUse();
            return new GetDatafeedStatsRequest(this);
        }
    }
}

