/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ccr.stats;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.DateTime;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class AutoFollowedCluster
implements JsonpSerializable {
    private final String clusterName;
    private final long lastSeenMetadataVersion;
    private final DateTime timeSinceLastCheckMillis;
    public static final JsonpDeserializer<AutoFollowedCluster> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, AutoFollowedCluster::setupAutoFollowedClusterDeserializer);

    private AutoFollowedCluster(Builder builder) {
        this.clusterName = ApiTypeHelper.requireNonNull(builder.clusterName, this, "clusterName");
        this.lastSeenMetadataVersion = ApiTypeHelper.requireNonNull(builder.lastSeenMetadataVersion, this, "lastSeenMetadataVersion");
        this.timeSinceLastCheckMillis = ApiTypeHelper.requireNonNull(builder.timeSinceLastCheckMillis, this, "timeSinceLastCheckMillis");
    }

    public static AutoFollowedCluster of(Function<Builder, ObjectBuilder<AutoFollowedCluster>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String clusterName() {
        return this.clusterName;
    }

    public final long lastSeenMetadataVersion() {
        return this.lastSeenMetadataVersion;
    }

    public final DateTime timeSinceLastCheckMillis() {
        return this.timeSinceLastCheckMillis;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("cluster_name");
        generator.write(this.clusterName);
        generator.writeKey("last_seen_metadata_version");
        generator.write(this.lastSeenMetadataVersion);
        generator.writeKey("time_since_last_check_millis");
        this.timeSinceLastCheckMillis.serialize(generator, mapper);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupAutoFollowedClusterDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::clusterName, JsonpDeserializer.stringDeserializer(), "cluster_name");
        op.add(Builder::lastSeenMetadataVersion, JsonpDeserializer.longDeserializer(), "last_seen_metadata_version");
        op.add(Builder::timeSinceLastCheckMillis, DateTime._DESERIALIZER, "time_since_last_check_millis");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<AutoFollowedCluster> {
        private String clusterName;
        private Long lastSeenMetadataVersion;
        private DateTime timeSinceLastCheckMillis;

        public final Builder clusterName(String value) {
            this.clusterName = value;
            return this;
        }

        public final Builder lastSeenMetadataVersion(long value) {
            this.lastSeenMetadataVersion = value;
            return this;
        }

        public final Builder timeSinceLastCheckMillis(DateTime value) {
            this.timeSinceLastCheckMillis = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public AutoFollowedCluster build() {
            this._checkSingleUse();
            return new AutoFollowedCluster(this);
        }
    }
}

