/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.security;

import co.elastic.clients.elasticsearch.security.User;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class UserProfile
implements JsonpSerializable {
    private final String uid;
    private final User user;
    private final Map<String, JsonData> data;
    private final Map<String, JsonData> access;
    @Nullable
    private final Boolean enabled;
    public static final JsonpDeserializer<UserProfile> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, UserProfile::setupUserProfileDeserializer);

    protected UserProfile(AbstractBuilder<?> builder) {
        this.uid = ApiTypeHelper.requireNonNull(((AbstractBuilder)builder).uid, this, "uid");
        this.user = ApiTypeHelper.requireNonNull(((AbstractBuilder)builder).user, this, "user");
        this.data = ApiTypeHelper.unmodifiable(((AbstractBuilder)builder).data);
        this.access = ApiTypeHelper.unmodifiable(((AbstractBuilder)builder).access);
        this.enabled = ((AbstractBuilder)builder).enabled;
    }

    public static UserProfile userProfileOf(Function<Builder, ObjectBuilder<UserProfile>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String uid() {
        return this.uid;
    }

    public final User user() {
        return this.user;
    }

    public final Map<String, JsonData> data() {
        return this.data;
    }

    public final Map<String, JsonData> access() {
        return this.access;
    }

    @Nullable
    public final Boolean enabled() {
        return this.enabled;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("uid");
        generator.write(this.uid);
        generator.writeKey("user");
        this.user.serialize(generator, mapper);
        if (ApiTypeHelper.isDefined(this.data)) {
            generator.writeKey("data");
            generator.writeStartObject();
            for (Map.Entry<String, JsonData> item0 : this.data.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.access)) {
            generator.writeKey("access");
            generator.writeStartObject();
            for (Map.Entry<String, JsonData> item0 : this.access.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.enabled != null) {
            generator.writeKey("enabled");
            generator.write(this.enabled.booleanValue());
        }
    }

    protected static <BuilderT extends AbstractBuilder<BuilderT>> void setupUserProfileDeserializer(ObjectDeserializer<BuilderT> op) {
        op.add(AbstractBuilder::uid, JsonpDeserializer.stringDeserializer(), "uid");
        op.add(AbstractBuilder::user, User._DESERIALIZER, "user");
        op.add(AbstractBuilder::data, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "data");
        op.add(AbstractBuilder::access, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "access");
        op.add(AbstractBuilder::enabled, JsonpDeserializer.booleanDeserializer(), "enabled");
    }

    protected static abstract class AbstractBuilder<BuilderT extends AbstractBuilder<BuilderT>>
    extends WithJsonObjectBuilderBase<BuilderT> {
        private String uid;
        private User user;
        @Nullable
        private Map<String, JsonData> data;
        @Nullable
        private Map<String, JsonData> access;
        @Nullable
        private Boolean enabled;

        protected AbstractBuilder() {
        }

        public final BuilderT uid(String value) {
            this.uid = value;
            return (BuilderT)this.self();
        }

        public final BuilderT user(User value) {
            this.user = value;
            return (BuilderT)this.self();
        }

        public final BuilderT user(Function<User.Builder, ObjectBuilder<User>> fn) {
            return this.user(fn.apply(new User.Builder()).build());
        }

        public final BuilderT data(Map<String, JsonData> map) {
            this.data = AbstractBuilder._mapPutAll(this.data, map);
            return (BuilderT)this.self();
        }

        public final BuilderT data(String key, JsonData value) {
            this.data = AbstractBuilder._mapPut(this.data, key, value);
            return (BuilderT)this.self();
        }

        public final BuilderT access(Map<String, JsonData> map) {
            this.access = AbstractBuilder._mapPutAll(this.access, map);
            return (BuilderT)this.self();
        }

        public final BuilderT access(String key, JsonData value) {
            this.access = AbstractBuilder._mapPut(this.access, key, value);
            return (BuilderT)this.self();
        }

        public final BuilderT enabled(@Nullable Boolean value) {
            this.enabled = value;
            return (BuilderT)this.self();
        }

        @Override
        protected abstract BuilderT self();
    }

    public static class Builder
    extends AbstractBuilder<Builder>
    implements ObjectBuilder<UserProfile> {
        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public UserProfile build() {
            this._checkSingleUse();
            return new UserProfile(this);
        }
    }
}

