/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.security;

import co.elastic.clients.elasticsearch.security.UserProfile;
import co.elastic.clients.elasticsearch.security.suggest_user_profiles.TotalUserProfiles;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public class SuggestUserProfilesResponse
implements JsonpSerializable {
    private final TotalUserProfiles total;
    private final long took;
    private final List<UserProfile> profiles;
    public static final JsonpDeserializer<SuggestUserProfilesResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SuggestUserProfilesResponse::setupSuggestUserProfilesResponseDeserializer);

    private SuggestUserProfilesResponse(Builder builder) {
        this.total = ApiTypeHelper.requireNonNull(builder.total, this, "total");
        this.took = ApiTypeHelper.requireNonNull(builder.took, this, "took");
        this.profiles = ApiTypeHelper.unmodifiableRequired(builder.profiles, (Object)this, "profiles");
    }

    public static SuggestUserProfilesResponse of(Function<Builder, ObjectBuilder<SuggestUserProfilesResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final TotalUserProfiles total() {
        return this.total;
    }

    public final long took() {
        return this.took;
    }

    public final List<UserProfile> profiles() {
        return this.profiles;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("total");
        this.total.serialize(generator, mapper);
        generator.writeKey("took");
        generator.write(this.took);
        if (ApiTypeHelper.isDefined(this.profiles)) {
            generator.writeKey("profiles");
            generator.writeStartArray();
            for (UserProfile item0 : this.profiles) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static void setupSuggestUserProfilesResponseDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::total, TotalUserProfiles._DESERIALIZER, "total");
        op.add(Builder::took, JsonpDeserializer.longDeserializer(), "took");
        op.add(Builder::profiles, JsonpDeserializer.arrayDeserializer(UserProfile._DESERIALIZER), "profiles");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<SuggestUserProfilesResponse> {
        private TotalUserProfiles total;
        private Long took;
        private List<UserProfile> profiles;

        public final Builder total(TotalUserProfiles value) {
            this.total = value;
            return this;
        }

        public final Builder total(Function<TotalUserProfiles.Builder, ObjectBuilder<TotalUserProfiles>> fn) {
            return this.total(fn.apply(new TotalUserProfiles.Builder()).build());
        }

        public final Builder took(long value) {
            this.took = value;
            return this;
        }

        public final Builder profiles(List<UserProfile> list) {
            this.profiles = Builder._listAddAll(this.profiles, list);
            return this;
        }

        public final Builder profiles(UserProfile value, UserProfile ... values) {
            this.profiles = Builder._listAdd(this.profiles, value, values);
            return this;
        }

        public final Builder profiles(Function<UserProfile.Builder, ObjectBuilder<UserProfile>> fn) {
            return this.profiles(fn.apply(new UserProfile.Builder()).build(), new UserProfile[0]);
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public SuggestUserProfilesResponse build() {
            this._checkSingleUse();
            return new SuggestUserProfilesResponse(this);
        }
    }
}

