/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ingest;

import co.elastic.clients.elasticsearch.ingest.InferenceConfig;
import co.elastic.clients.elasticsearch.ingest.InferenceConfigVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class InferenceConfigClassification
implements InferenceConfigVariant,
JsonpSerializable {
    @Nullable
    private final Integer numTopClasses;
    @Nullable
    private final Integer numTopFeatureImportanceValues;
    @Nullable
    private final String resultsField;
    @Nullable
    private final String topClassesResultsField;
    @Nullable
    private final String predictionFieldType;
    public static final JsonpDeserializer<InferenceConfigClassification> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, InferenceConfigClassification::setupInferenceConfigClassificationDeserializer);

    private InferenceConfigClassification(Builder builder) {
        this.numTopClasses = builder.numTopClasses;
        this.numTopFeatureImportanceValues = builder.numTopFeatureImportanceValues;
        this.resultsField = builder.resultsField;
        this.topClassesResultsField = builder.topClassesResultsField;
        this.predictionFieldType = builder.predictionFieldType;
    }

    public static InferenceConfigClassification of(Function<Builder, ObjectBuilder<InferenceConfigClassification>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public InferenceConfig.Kind _inferenceConfigKind() {
        return InferenceConfig.Kind.Classification;
    }

    @Nullable
    public final Integer numTopClasses() {
        return this.numTopClasses;
    }

    @Nullable
    public final Integer numTopFeatureImportanceValues() {
        return this.numTopFeatureImportanceValues;
    }

    @Nullable
    public final String resultsField() {
        return this.resultsField;
    }

    @Nullable
    public final String topClassesResultsField() {
        return this.topClassesResultsField;
    }

    @Nullable
    public final String predictionFieldType() {
        return this.predictionFieldType;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.numTopClasses != null) {
            generator.writeKey("num_top_classes");
            generator.write(this.numTopClasses.intValue());
        }
        if (this.numTopFeatureImportanceValues != null) {
            generator.writeKey("num_top_feature_importance_values");
            generator.write(this.numTopFeatureImportanceValues.intValue());
        }
        if (this.resultsField != null) {
            generator.writeKey("results_field");
            generator.write(this.resultsField);
        }
        if (this.topClassesResultsField != null) {
            generator.writeKey("top_classes_results_field");
            generator.write(this.topClassesResultsField);
        }
        if (this.predictionFieldType != null) {
            generator.writeKey("prediction_field_type");
            generator.write(this.predictionFieldType);
        }
    }

    protected static void setupInferenceConfigClassificationDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::numTopClasses, JsonpDeserializer.integerDeserializer(), "num_top_classes");
        op.add(Builder::numTopFeatureImportanceValues, JsonpDeserializer.integerDeserializer(), "num_top_feature_importance_values");
        op.add(Builder::resultsField, JsonpDeserializer.stringDeserializer(), "results_field");
        op.add(Builder::topClassesResultsField, JsonpDeserializer.stringDeserializer(), "top_classes_results_field");
        op.add(Builder::predictionFieldType, JsonpDeserializer.stringDeserializer(), "prediction_field_type");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<InferenceConfigClassification> {
        @Nullable
        private Integer numTopClasses;
        @Nullable
        private Integer numTopFeatureImportanceValues;
        @Nullable
        private String resultsField;
        @Nullable
        private String topClassesResultsField;
        @Nullable
        private String predictionFieldType;

        public final Builder numTopClasses(@Nullable Integer value) {
            this.numTopClasses = value;
            return this;
        }

        public final Builder numTopFeatureImportanceValues(@Nullable Integer value) {
            this.numTopFeatureImportanceValues = value;
            return this;
        }

        public final Builder resultsField(@Nullable String value) {
            this.resultsField = value;
            return this;
        }

        public final Builder topClassesResultsField(@Nullable String value) {
            this.topClassesResultsField = value;
            return this;
        }

        public final Builder predictionFieldType(@Nullable String value) {
            this.predictionFieldType = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public InferenceConfigClassification build() {
            this._checkSingleUse();
            return new InferenceConfigClassification(this);
        }
    }
}

