/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices.field_usage_stats;

import co.elastic.clients.elasticsearch.indices.field_usage_stats.FieldSummary;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.function.Function;

@JsonpDeserializable
public class ShardsStats
implements JsonpSerializable {
    private final FieldSummary allFields;
    private final Map<String, FieldSummary> fields;
    public static final JsonpDeserializer<ShardsStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ShardsStats::setupShardsStatsDeserializer);

    private ShardsStats(Builder builder) {
        this.allFields = ApiTypeHelper.requireNonNull(builder.allFields, this, "allFields");
        this.fields = ApiTypeHelper.unmodifiableRequired(builder.fields, (Object)this, "fields");
    }

    public static ShardsStats of(Function<Builder, ObjectBuilder<ShardsStats>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final FieldSummary allFields() {
        return this.allFields;
    }

    public final Map<String, FieldSummary> fields() {
        return this.fields;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("all_fields");
        this.allFields.serialize(generator, mapper);
        if (ApiTypeHelper.isDefined(this.fields)) {
            generator.writeKey("fields");
            generator.writeStartObject();
            for (Map.Entry<String, FieldSummary> item0 : this.fields.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static void setupShardsStatsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::allFields, FieldSummary._DESERIALIZER, "all_fields");
        op.add(Builder::fields, JsonpDeserializer.stringMapDeserializer(FieldSummary._DESERIALIZER), "fields");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<ShardsStats> {
        private FieldSummary allFields;
        private Map<String, FieldSummary> fields;

        public final Builder allFields(FieldSummary value) {
            this.allFields = value;
            return this;
        }

        public final Builder allFields(Function<FieldSummary.Builder, ObjectBuilder<FieldSummary>> fn) {
            return this.allFields(fn.apply(new FieldSummary.Builder()).build());
        }

        public final Builder fields(Map<String, FieldSummary> map) {
            this.fields = Builder._mapPutAll(this.fields, map);
            return this;
        }

        public final Builder fields(String key, FieldSummary value) {
            this.fields = Builder._mapPut(this.fields, key, value);
            return this;
        }

        public final Builder fields(String key, Function<FieldSummary.Builder, ObjectBuilder<FieldSummary>> fn) {
            return this.fields(key, fn.apply(new FieldSummary.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ShardsStats build() {
            this._checkSingleUse();
            return new ShardsStats(this);
        }
    }
}

