/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices.field_usage_stats;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class InvertedIndex
implements JsonpSerializable {
    private final Number terms;
    private final Number postings;
    private final Number proximity;
    private final Number positions;
    private final Number termFrequencies;
    private final Number offsets;
    private final Number payloads;
    public static final JsonpDeserializer<InvertedIndex> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, InvertedIndex::setupInvertedIndexDeserializer);

    private InvertedIndex(Builder builder) {
        this.terms = ApiTypeHelper.requireNonNull(builder.terms, this, "terms");
        this.postings = ApiTypeHelper.requireNonNull(builder.postings, this, "postings");
        this.proximity = ApiTypeHelper.requireNonNull(builder.proximity, this, "proximity");
        this.positions = ApiTypeHelper.requireNonNull(builder.positions, this, "positions");
        this.termFrequencies = ApiTypeHelper.requireNonNull(builder.termFrequencies, this, "termFrequencies");
        this.offsets = ApiTypeHelper.requireNonNull(builder.offsets, this, "offsets");
        this.payloads = ApiTypeHelper.requireNonNull(builder.payloads, this, "payloads");
    }

    public static InvertedIndex of(Function<Builder, ObjectBuilder<InvertedIndex>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final Number terms() {
        return this.terms;
    }

    public final Number postings() {
        return this.postings;
    }

    public final Number proximity() {
        return this.proximity;
    }

    public final Number positions() {
        return this.positions;
    }

    public final Number termFrequencies() {
        return this.termFrequencies;
    }

    public final Number offsets() {
        return this.offsets;
    }

    public final Number payloads() {
        return this.payloads;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("terms");
        generator.write(this.terms.doubleValue());
        generator.writeKey("postings");
        generator.write(this.postings.doubleValue());
        generator.writeKey("proximity");
        generator.write(this.proximity.doubleValue());
        generator.writeKey("positions");
        generator.write(this.positions.doubleValue());
        generator.writeKey("term_frequencies");
        generator.write(this.termFrequencies.doubleValue());
        generator.writeKey("offsets");
        generator.write(this.offsets.doubleValue());
        generator.writeKey("payloads");
        generator.write(this.payloads.doubleValue());
    }

    protected static void setupInvertedIndexDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::terms, JsonpDeserializer.numberDeserializer(), "terms");
        op.add(Builder::postings, JsonpDeserializer.numberDeserializer(), "postings");
        op.add(Builder::proximity, JsonpDeserializer.numberDeserializer(), "proximity");
        op.add(Builder::positions, JsonpDeserializer.numberDeserializer(), "positions");
        op.add(Builder::termFrequencies, JsonpDeserializer.numberDeserializer(), "term_frequencies");
        op.add(Builder::offsets, JsonpDeserializer.numberDeserializer(), "offsets");
        op.add(Builder::payloads, JsonpDeserializer.numberDeserializer(), "payloads");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<InvertedIndex> {
        private Number terms;
        private Number postings;
        private Number proximity;
        private Number positions;
        private Number termFrequencies;
        private Number offsets;
        private Number payloads;

        public final Builder terms(Number value) {
            this.terms = value;
            return this;
        }

        public final Builder postings(Number value) {
            this.postings = value;
            return this;
        }

        public final Builder proximity(Number value) {
            this.proximity = value;
            return this;
        }

        public final Builder positions(Number value) {
            this.positions = value;
            return this;
        }

        public final Builder termFrequencies(Number value) {
            this.termFrequencies = value;
            return this;
        }

        public final Builder offsets(Number value) {
            this.offsets = value;
            return this;
        }

        public final Builder payloads(Number value) {
            this.payloads = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public InvertedIndex build() {
            this._checkSingleUse();
            return new InvertedIndex(this);
        }
    }
}

