/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.graph;

import co.elastic.clients.elasticsearch.graph.VertexInclude;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class VertexDefinition
implements JsonpSerializable {
    private final List<String> exclude;
    private final String field;
    private final List<VertexInclude> include;
    @Nullable
    private final Long minDocCount;
    @Nullable
    private final Long shardMinDocCount;
    @Nullable
    private final Integer size;
    public static final JsonpDeserializer<VertexDefinition> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, VertexDefinition::setupVertexDefinitionDeserializer);

    private VertexDefinition(Builder builder) {
        this.exclude = ApiTypeHelper.unmodifiable(builder.exclude);
        this.field = ApiTypeHelper.requireNonNull(builder.field, this, "field");
        this.include = ApiTypeHelper.unmodifiable(builder.include);
        this.minDocCount = builder.minDocCount;
        this.shardMinDocCount = builder.shardMinDocCount;
        this.size = builder.size;
    }

    public static VertexDefinition of(Function<Builder, ObjectBuilder<VertexDefinition>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<String> exclude() {
        return this.exclude;
    }

    public final String field() {
        return this.field;
    }

    public final List<VertexInclude> include() {
        return this.include;
    }

    @Nullable
    public final Long minDocCount() {
        return this.minDocCount;
    }

    @Nullable
    public final Long shardMinDocCount() {
        return this.shardMinDocCount;
    }

    @Nullable
    public final Integer size() {
        return this.size;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.exclude)) {
            generator.writeKey("exclude");
            generator.writeStartArray();
            for (String string : this.exclude) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        generator.writeKey("field");
        generator.write(this.field);
        if (ApiTypeHelper.isDefined(this.include)) {
            generator.writeKey("include");
            generator.writeStartArray();
            for (VertexInclude vertexInclude : this.include) {
                vertexInclude.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.minDocCount != null) {
            generator.writeKey("min_doc_count");
            generator.write(this.minDocCount.longValue());
        }
        if (this.shardMinDocCount != null) {
            generator.writeKey("shard_min_doc_count");
            generator.write(this.shardMinDocCount.longValue());
        }
        if (this.size != null) {
            generator.writeKey("size");
            generator.write(this.size.intValue());
        }
    }

    protected static void setupVertexDefinitionDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::exclude, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "exclude");
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field");
        op.add(Builder::include, JsonpDeserializer.arrayDeserializer(VertexInclude._DESERIALIZER), "include");
        op.add(Builder::minDocCount, JsonpDeserializer.longDeserializer(), "min_doc_count");
        op.add(Builder::shardMinDocCount, JsonpDeserializer.longDeserializer(), "shard_min_doc_count");
        op.add(Builder::size, JsonpDeserializer.integerDeserializer(), "size");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<VertexDefinition> {
        @Nullable
        private List<String> exclude;
        private String field;
        @Nullable
        private List<VertexInclude> include;
        @Nullable
        private Long minDocCount;
        @Nullable
        private Long shardMinDocCount;
        @Nullable
        private Integer size;

        public final Builder exclude(List<String> list) {
            this.exclude = Builder._listAddAll(this.exclude, list);
            return this;
        }

        public final Builder exclude(String value, String ... values) {
            this.exclude = Builder._listAdd(this.exclude, value, values);
            return this;
        }

        public final Builder field(String value) {
            this.field = value;
            return this;
        }

        public final Builder include(List<VertexInclude> list) {
            this.include = Builder._listAddAll(this.include, list);
            return this;
        }

        public final Builder include(VertexInclude value, VertexInclude ... values) {
            this.include = Builder._listAdd(this.include, value, values);
            return this;
        }

        public final Builder include(Function<VertexInclude.Builder, ObjectBuilder<VertexInclude>> fn) {
            return this.include(fn.apply(new VertexInclude.Builder()).build(), new VertexInclude[0]);
        }

        public final Builder minDocCount(@Nullable Long value) {
            this.minDocCount = value;
            return this;
        }

        public final Builder shardMinDocCount(@Nullable Long value) {
            this.shardMinDocCount = value;
            return this;
        }

        public final Builder size(@Nullable Integer value) {
            this.size = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public VertexDefinition build() {
            this._checkSingleUse();
            return new VertexDefinition(this);
        }
    }
}

