/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.elasticsearch._types.aggregations.TermsBucketBase;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class DoubleTermsBucket
extends TermsBucketBase {
    private final double key;
    @Nullable
    private final String keyAsString;
    public static final JsonpDeserializer<DoubleTermsBucket> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DoubleTermsBucket::setupDoubleTermsBucketDeserializer);

    private DoubleTermsBucket(Builder builder) {
        super(builder);
        this.key = ApiTypeHelper.requireNonNull(builder.key, this, "key");
        this.keyAsString = builder.keyAsString;
    }

    public static DoubleTermsBucket of(Function<Builder, ObjectBuilder<DoubleTermsBucket>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final double key() {
        return this.key;
    }

    @Nullable
    public final String keyAsString() {
        return this.keyAsString;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("key");
        generator.write(this.key);
        if (this.keyAsString != null) {
            generator.writeKey("key_as_string");
            generator.write(this.keyAsString);
        }
    }

    protected static void setupDoubleTermsBucketDeserializer(ObjectDeserializer<Builder> op) {
        TermsBucketBase.setupTermsBucketBaseDeserializer(op);
        op.add(Builder::key, JsonpDeserializer.doubleDeserializer(), "key");
        op.add(Builder::keyAsString, JsonpDeserializer.stringDeserializer(), "key_as_string");
    }

    public static class Builder
    extends TermsBucketBase.AbstractBuilder<Builder>
    implements ObjectBuilder<DoubleTermsBucket> {
        private Double key;
        @Nullable
        private String keyAsString;

        public final Builder key(double value) {
            this.key = value;
            return this;
        }

        public final Builder keyAsString(@Nullable String value) {
            this.keyAsString = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public DoubleTermsBucket build() {
            this._checkSingleUse();
            return new DoubleTermsBucket(this);
        }
    }
}

