/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.security;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.security.DelegatePkiResponse;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public class DelegatePkiRequest
extends RequestBase
implements JsonpSerializable {
    private final List<String> x509CertificateChain;
    public static final JsonpDeserializer<DelegatePkiRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DelegatePkiRequest::setupDelegatePkiRequestDeserializer);
    public static final Endpoint<DelegatePkiRequest, DelegatePkiResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<DelegatePkiRequest, DelegatePkiResponse>("es/security.delegate_pki", request -> "POST", request -> "/_security/delegate_pki", request -> Collections.emptyMap(), request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), true, DelegatePkiResponse._DESERIALIZER);

    private DelegatePkiRequest(Builder builder) {
        this.x509CertificateChain = ApiTypeHelper.unmodifiableRequired(builder.x509CertificateChain, (Object)this, "x509CertificateChain");
    }

    public static DelegatePkiRequest of(Function<Builder, ObjectBuilder<DelegatePkiRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<String> x509CertificateChain() {
        return this.x509CertificateChain;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.x509CertificateChain)) {
            generator.writeKey("x509_certificate_chain");
            generator.writeStartArray();
            for (String item0 : this.x509CertificateChain) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
    }

    protected static void setupDelegatePkiRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::x509CertificateChain, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "x509_certificate_chain");
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<DelegatePkiRequest> {
        private List<String> x509CertificateChain;

        public final Builder x509CertificateChain(List<String> list) {
            this.x509CertificateChain = Builder._listAddAll(this.x509CertificateChain, list);
            return this;
        }

        public final Builder x509CertificateChain(String value, String ... values) {
            this.x509CertificateChain = Builder._listAdd(this.x509CertificateChain, value, values);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public DelegatePkiRequest build() {
            this._checkSingleUse();
            return new DelegatePkiRequest(this);
        }
    }
}

