/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.inference;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class VoyageAITaskSettings
implements JsonpSerializable {
    @Nullable
    private final String inputType;
    @Nullable
    private final Boolean returnDocuments;
    @Nullable
    private final Integer topK;
    @Nullable
    private final Boolean truncation;
    public static final JsonpDeserializer<VoyageAITaskSettings> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, VoyageAITaskSettings::setupVoyageAITaskSettingsDeserializer);

    private VoyageAITaskSettings(Builder builder) {
        this.inputType = builder.inputType;
        this.returnDocuments = builder.returnDocuments;
        this.topK = builder.topK;
        this.truncation = builder.truncation;
    }

    public static VoyageAITaskSettings of(Function<Builder, ObjectBuilder<VoyageAITaskSettings>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String inputType() {
        return this.inputType;
    }

    @Nullable
    public final Boolean returnDocuments() {
        return this.returnDocuments;
    }

    @Nullable
    public final Integer topK() {
        return this.topK;
    }

    @Nullable
    public final Boolean truncation() {
        return this.truncation;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.inputType != null) {
            generator.writeKey("input_type");
            generator.write(this.inputType);
        }
        if (this.returnDocuments != null) {
            generator.writeKey("return_documents");
            generator.write(this.returnDocuments.booleanValue());
        }
        if (this.topK != null) {
            generator.writeKey("top_k");
            generator.write(this.topK.intValue());
        }
        if (this.truncation != null) {
            generator.writeKey("truncation");
            generator.write(this.truncation.booleanValue());
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupVoyageAITaskSettingsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::inputType, JsonpDeserializer.stringDeserializer(), "input_type");
        op.add(Builder::returnDocuments, JsonpDeserializer.booleanDeserializer(), "return_documents");
        op.add(Builder::topK, JsonpDeserializer.integerDeserializer(), "top_k");
        op.add(Builder::truncation, JsonpDeserializer.booleanDeserializer(), "truncation");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<VoyageAITaskSettings> {
        @Nullable
        private String inputType;
        @Nullable
        private Boolean returnDocuments;
        @Nullable
        private Integer topK;
        @Nullable
        private Boolean truncation;

        public final Builder inputType(@Nullable String value) {
            this.inputType = value;
            return this;
        }

        public final Builder returnDocuments(@Nullable Boolean value) {
            this.returnDocuments = value;
            return this;
        }

        public final Builder topK(@Nullable Integer value) {
            this.topK = value;
            return this;
        }

        public final Builder truncation(@Nullable Boolean value) {
            this.truncation = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public VoyageAITaskSettings build() {
            this._checkSingleUse();
            return new VoyageAITaskSettings(this);
        }
    }
}

