/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices;

import co.elastic.clients.elasticsearch.indices.resolve_index.ResolveIndexAliasItem;
import co.elastic.clients.elasticsearch.indices.resolve_index.ResolveIndexDataStreamsItem;
import co.elastic.clients.elasticsearch.indices.resolve_index.ResolveIndexItem;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public class ResolveIndexResponse
implements JsonpSerializable {
    private final List<ResolveIndexItem> indices;
    private final List<ResolveIndexAliasItem> aliases;
    private final List<ResolveIndexDataStreamsItem> dataStreams;
    public static final JsonpDeserializer<ResolveIndexResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ResolveIndexResponse::setupResolveIndexResponseDeserializer);

    private ResolveIndexResponse(Builder builder) {
        this.indices = ApiTypeHelper.unmodifiableRequired(builder.indices, (Object)this, "indices");
        this.aliases = ApiTypeHelper.unmodifiableRequired(builder.aliases, (Object)this, "aliases");
        this.dataStreams = ApiTypeHelper.unmodifiableRequired(builder.dataStreams, (Object)this, "dataStreams");
    }

    public static ResolveIndexResponse of(Function<Builder, ObjectBuilder<ResolveIndexResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<ResolveIndexItem> indices() {
        return this.indices;
    }

    public final List<ResolveIndexAliasItem> aliases() {
        return this.aliases;
    }

    public final List<ResolveIndexDataStreamsItem> dataStreams() {
        return this.dataStreams;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.indices)) {
            generator.writeKey("indices");
            generator.writeStartArray();
            for (ResolveIndexItem resolveIndexItem : this.indices) {
                resolveIndexItem.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.aliases)) {
            generator.writeKey("aliases");
            generator.writeStartArray();
            for (ResolveIndexAliasItem resolveIndexAliasItem : this.aliases) {
                resolveIndexAliasItem.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.dataStreams)) {
            generator.writeKey("data_streams");
            generator.writeStartArray();
            for (ResolveIndexDataStreamsItem resolveIndexDataStreamsItem : this.dataStreams) {
                resolveIndexDataStreamsItem.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupResolveIndexResponseDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::indices, JsonpDeserializer.arrayDeserializer(ResolveIndexItem._DESERIALIZER), "indices");
        op.add(Builder::aliases, JsonpDeserializer.arrayDeserializer(ResolveIndexAliasItem._DESERIALIZER), "aliases");
        op.add(Builder::dataStreams, JsonpDeserializer.arrayDeserializer(ResolveIndexDataStreamsItem._DESERIALIZER), "data_streams");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<ResolveIndexResponse> {
        private List<ResolveIndexItem> indices;
        private List<ResolveIndexAliasItem> aliases;
        private List<ResolveIndexDataStreamsItem> dataStreams;

        public final Builder indices(List<ResolveIndexItem> list) {
            this.indices = Builder._listAddAll(this.indices, list);
            return this;
        }

        public final Builder indices(ResolveIndexItem value, ResolveIndexItem ... values) {
            this.indices = Builder._listAdd(this.indices, value, values);
            return this;
        }

        public final Builder indices(Function<ResolveIndexItem.Builder, ObjectBuilder<ResolveIndexItem>> fn) {
            return this.indices(fn.apply(new ResolveIndexItem.Builder()).build(), new ResolveIndexItem[0]);
        }

        public final Builder aliases(List<ResolveIndexAliasItem> list) {
            this.aliases = Builder._listAddAll(this.aliases, list);
            return this;
        }

        public final Builder aliases(ResolveIndexAliasItem value, ResolveIndexAliasItem ... values) {
            this.aliases = Builder._listAdd(this.aliases, value, values);
            return this;
        }

        public final Builder aliases(Function<ResolveIndexAliasItem.Builder, ObjectBuilder<ResolveIndexAliasItem>> fn) {
            return this.aliases(fn.apply(new ResolveIndexAliasItem.Builder()).build(), new ResolveIndexAliasItem[0]);
        }

        public final Builder dataStreams(List<ResolveIndexDataStreamsItem> list) {
            this.dataStreams = Builder._listAddAll(this.dataStreams, list);
            return this;
        }

        public final Builder dataStreams(ResolveIndexDataStreamsItem value, ResolveIndexDataStreamsItem ... values) {
            this.dataStreams = Builder._listAdd(this.dataStreams, value, values);
            return this;
        }

        public final Builder dataStreams(Function<ResolveIndexDataStreamsItem.Builder, ObjectBuilder<ResolveIndexDataStreamsItem>> fn) {
            return this.dataStreams(fn.apply(new ResolveIndexDataStreamsItem.Builder()).build(), new ResolveIndexDataStreamsItem[0]);
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ResolveIndexResponse build() {
            this._checkSingleUse();
            return new ResolveIndexResponse(this);
        }
    }
}

