/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.security;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.security.ClusterPrivilege;
import co.elastic.clients.elasticsearch.security.HasPrivilegesResponse;
import co.elastic.clients.elasticsearch.security.has_privileges.ApplicationPrivilegesCheck;
import co.elastic.clients.elasticsearch.security.has_privileges.IndexPrivilegesCheck;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class HasPrivilegesRequest
extends RequestBase
implements JsonpSerializable {
    private final List<ApplicationPrivilegesCheck> application;
    private final List<String> cluster;
    private final List<IndexPrivilegesCheck> index;
    @Nullable
    private final String user;
    public static final JsonpDeserializer<HasPrivilegesRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, HasPrivilegesRequest::setupHasPrivilegesRequestDeserializer);
    public static final Endpoint<HasPrivilegesRequest, HasPrivilegesResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<HasPrivilegesRequest, HasPrivilegesResponse>("es/security.has_privileges", request -> "POST", request -> {
        boolean _user = true;
        boolean propsSet = false;
        if (request.user() != null) {
            propsSet |= true;
        }
        if (!propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_security");
            buf.append("/user");
            buf.append("/_has_privileges");
            return buf.toString();
        }
        if (propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_security");
            buf.append("/user");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.user, buf);
            buf.append("/_has_privileges");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        boolean _user = true;
        boolean propsSet = false;
        if (request.user() != null) {
            propsSet |= true;
        }
        if (!propsSet) {
            // empty if block
        }
        if (propsSet) {
            params.put("user", request.user);
        }
        return params;
    }, request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), true, HasPrivilegesResponse._DESERIALIZER);

    private HasPrivilegesRequest(Builder builder) {
        this.application = ApiTypeHelper.unmodifiable(builder.application);
        this.cluster = ApiTypeHelper.unmodifiable(builder.cluster);
        this.index = ApiTypeHelper.unmodifiable(builder.index);
        this.user = builder.user;
    }

    public static HasPrivilegesRequest of(Function<Builder, ObjectBuilder<HasPrivilegesRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<ApplicationPrivilegesCheck> application() {
        return this.application;
    }

    public final List<String> cluster() {
        return this.cluster;
    }

    public final List<IndexPrivilegesCheck> index() {
        return this.index;
    }

    @Nullable
    public final String user() {
        return this.user;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.application)) {
            generator.writeKey("application");
            generator.writeStartArray();
            for (ApplicationPrivilegesCheck applicationPrivilegesCheck : this.application) {
                applicationPrivilegesCheck.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.cluster)) {
            generator.writeKey("cluster");
            generator.writeStartArray();
            for (String string : this.cluster) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.index)) {
            generator.writeKey("index");
            generator.writeStartArray();
            for (IndexPrivilegesCheck indexPrivilegesCheck : this.index) {
                indexPrivilegesCheck.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static void setupHasPrivilegesRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::application, JsonpDeserializer.arrayDeserializer(ApplicationPrivilegesCheck._DESERIALIZER), "application");
        op.add(Builder::cluster, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "cluster");
        op.add(Builder::index, JsonpDeserializer.arrayDeserializer(IndexPrivilegesCheck._DESERIALIZER), "index");
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<HasPrivilegesRequest> {
        @Nullable
        private List<ApplicationPrivilegesCheck> application;
        @Nullable
        private List<String> cluster;
        @Nullable
        private List<IndexPrivilegesCheck> index;
        @Nullable
        private String user;

        public final Builder application(List<ApplicationPrivilegesCheck> list) {
            this.application = Builder._listAddAll(this.application, list);
            return this;
        }

        public final Builder application(ApplicationPrivilegesCheck value, ApplicationPrivilegesCheck ... values) {
            this.application = Builder._listAdd(this.application, value, values);
            return this;
        }

        public final Builder application(Function<ApplicationPrivilegesCheck.Builder, ObjectBuilder<ApplicationPrivilegesCheck>> fn) {
            return this.application(fn.apply(new ApplicationPrivilegesCheck.Builder()).build(), new ApplicationPrivilegesCheck[0]);
        }

        public final Builder cluster(List<String> list) {
            this.cluster = Builder._listAddAll(this.cluster, list);
            return this;
        }

        public final Builder cluster(String value, String ... values) {
            this.cluster = Builder._listAdd(this.cluster, value, values);
            return this;
        }

        public final Builder cluster(ClusterPrivilege value, ClusterPrivilege ... values) {
            this.cluster = Builder._listAdd(this.cluster, value.jsonValue(), (String[])Arrays.stream(values).map(ClusterPrivilege::jsonValue).toArray(String[]::new));
            return this;
        }

        public final Builder index(List<IndexPrivilegesCheck> list) {
            this.index = Builder._listAddAll(this.index, list);
            return this;
        }

        public final Builder index(IndexPrivilegesCheck value, IndexPrivilegesCheck ... values) {
            this.index = Builder._listAdd(this.index, value, values);
            return this;
        }

        public final Builder index(Function<IndexPrivilegesCheck.Builder, ObjectBuilder<IndexPrivilegesCheck>> fn) {
            return this.index(fn.apply(new IndexPrivilegesCheck.Builder()).build(), new IndexPrivilegesCheck[0]);
        }

        public final Builder user(@Nullable String value) {
            this.user = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public HasPrivilegesRequest build() {
            this._checkSingleUse();
            return new HasPrivilegesRequest(this);
        }
    }
}

