/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.inference;

import co.elastic.clients.elasticsearch.inference.RateLimitSetting;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class AzureOpenAIServiceSettings
implements JsonpSerializable {
    @Nullable
    private final String apiKey;
    private final String apiVersion;
    private final String deploymentId;
    @Nullable
    private final String entraId;
    @Nullable
    private final RateLimitSetting rateLimit;
    private final String resourceName;
    public static final JsonpDeserializer<AzureOpenAIServiceSettings> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, AzureOpenAIServiceSettings::setupAzureOpenAIServiceSettingsDeserializer);

    private AzureOpenAIServiceSettings(Builder builder) {
        this.apiKey = builder.apiKey;
        this.apiVersion = ApiTypeHelper.requireNonNull(builder.apiVersion, this, "apiVersion");
        this.deploymentId = ApiTypeHelper.requireNonNull(builder.deploymentId, this, "deploymentId");
        this.entraId = builder.entraId;
        this.rateLimit = builder.rateLimit;
        this.resourceName = ApiTypeHelper.requireNonNull(builder.resourceName, this, "resourceName");
    }

    public static AzureOpenAIServiceSettings of(Function<Builder, ObjectBuilder<AzureOpenAIServiceSettings>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String apiKey() {
        return this.apiKey;
    }

    public final String apiVersion() {
        return this.apiVersion;
    }

    public final String deploymentId() {
        return this.deploymentId;
    }

    @Nullable
    public final String entraId() {
        return this.entraId;
    }

    @Nullable
    public final RateLimitSetting rateLimit() {
        return this.rateLimit;
    }

    public final String resourceName() {
        return this.resourceName;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.apiKey != null) {
            generator.writeKey("api_key");
            generator.write(this.apiKey);
        }
        generator.writeKey("api_version");
        generator.write(this.apiVersion);
        generator.writeKey("deployment_id");
        generator.write(this.deploymentId);
        if (this.entraId != null) {
            generator.writeKey("entra_id");
            generator.write(this.entraId);
        }
        if (this.rateLimit != null) {
            generator.writeKey("rate_limit");
            this.rateLimit.serialize(generator, mapper);
        }
        generator.writeKey("resource_name");
        generator.write(this.resourceName);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupAzureOpenAIServiceSettingsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::apiKey, JsonpDeserializer.stringDeserializer(), "api_key");
        op.add(Builder::apiVersion, JsonpDeserializer.stringDeserializer(), "api_version");
        op.add(Builder::deploymentId, JsonpDeserializer.stringDeserializer(), "deployment_id");
        op.add(Builder::entraId, JsonpDeserializer.stringDeserializer(), "entra_id");
        op.add(Builder::rateLimit, RateLimitSetting._DESERIALIZER, "rate_limit");
        op.add(Builder::resourceName, JsonpDeserializer.stringDeserializer(), "resource_name");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<AzureOpenAIServiceSettings> {
        @Nullable
        private String apiKey;
        private String apiVersion;
        private String deploymentId;
        @Nullable
        private String entraId;
        @Nullable
        private RateLimitSetting rateLimit;
        private String resourceName;

        public final Builder apiKey(@Nullable String value) {
            this.apiKey = value;
            return this;
        }

        public final Builder apiVersion(String value) {
            this.apiVersion = value;
            return this;
        }

        public final Builder deploymentId(String value) {
            this.deploymentId = value;
            return this;
        }

        public final Builder entraId(@Nullable String value) {
            this.entraId = value;
            return this;
        }

        public final Builder rateLimit(@Nullable RateLimitSetting value) {
            this.rateLimit = value;
            return this;
        }

        public final Builder rateLimit(Function<RateLimitSetting.Builder, ObjectBuilder<RateLimitSetting>> fn) {
            return this.rateLimit(fn.apply(new RateLimitSetting.Builder()).build());
        }

        public final Builder resourceName(String value) {
            this.resourceName = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public AzureOpenAIServiceSettings build() {
            this._checkSingleUse();
            return new AzureOpenAIServiceSettings(this);
        }
    }
}

