/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core.search;

import co.elastic.clients.elasticsearch.core.search.SmoothingModel;
import co.elastic.clients.elasticsearch.core.search.SmoothingModelVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class LinearInterpolationSmoothingModel
implements SmoothingModelVariant,
JsonpSerializable {
    private final double bigramLambda;
    private final double trigramLambda;
    private final double unigramLambda;
    public static final JsonpDeserializer<LinearInterpolationSmoothingModel> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, LinearInterpolationSmoothingModel::setupLinearInterpolationSmoothingModelDeserializer);

    private LinearInterpolationSmoothingModel(Builder builder) {
        this.bigramLambda = ApiTypeHelper.requireNonNull(builder.bigramLambda, (Object)this, "bigramLambda", 0.0);
        this.trigramLambda = ApiTypeHelper.requireNonNull(builder.trigramLambda, (Object)this, "trigramLambda", 0.0);
        this.unigramLambda = ApiTypeHelper.requireNonNull(builder.unigramLambda, (Object)this, "unigramLambda", 0.0);
    }

    public static LinearInterpolationSmoothingModel of(Function<Builder, ObjectBuilder<LinearInterpolationSmoothingModel>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public SmoothingModel.Kind _smoothingModelKind() {
        return SmoothingModel.Kind.LinearInterpolation;
    }

    public final double bigramLambda() {
        return this.bigramLambda;
    }

    public final double trigramLambda() {
        return this.trigramLambda;
    }

    public final double unigramLambda() {
        return this.unigramLambda;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("bigram_lambda");
        generator.write(this.bigramLambda);
        generator.writeKey("trigram_lambda");
        generator.write(this.trigramLambda);
        generator.writeKey("unigram_lambda");
        generator.write(this.unigramLambda);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupLinearInterpolationSmoothingModelDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::bigramLambda, JsonpDeserializer.doubleDeserializer(), "bigram_lambda");
        op.add(Builder::trigramLambda, JsonpDeserializer.doubleDeserializer(), "trigram_lambda");
        op.add(Builder::unigramLambda, JsonpDeserializer.doubleDeserializer(), "unigram_lambda");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<LinearInterpolationSmoothingModel> {
        private Double bigramLambda;
        private Double trigramLambda;
        private Double unigramLambda;

        public final Builder bigramLambda(double value) {
            this.bigramLambda = value;
            return this;
        }

        public final Builder trigramLambda(double value) {
            this.trigramLambda = value;
            return this;
        }

        public final Builder unigramLambda(double value) {
            this.unigramLambda = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public LinearInterpolationSmoothingModel build() {
            this._checkSingleUse();
            return new LinearInterpolationSmoothingModel(this);
        }
    }
}

