/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.transform;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch.transform.StopTransformResponse;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import java.util.HashMap;
import java.util.function.Function;
import javax.annotation.Nullable;

public class StopTransformRequest
extends RequestBase {
    @Nullable
    private final Boolean allowNoMatch;
    @Nullable
    private final Boolean force;
    @Nullable
    private final Time timeout;
    private final String transformId;
    @Nullable
    private final Boolean waitForCheckpoint;
    @Nullable
    private final Boolean waitForCompletion;
    public static final Endpoint<StopTransformRequest, StopTransformResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<StopTransformRequest, StopTransformResponse>("es/transform.stop_transform", request -> "POST", request -> {
        boolean _transformId = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_transform");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.transformId, buf);
            buf.append("/_stop");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        boolean _transformId = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            params.put("transformId", request.transformId);
        }
        return params;
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.waitForCheckpoint != null) {
            params.put("wait_for_checkpoint", String.valueOf(request.waitForCheckpoint));
        }
        if (request.force != null) {
            params.put("force", String.valueOf(request.force));
        }
        if (request.waitForCompletion != null) {
            params.put("wait_for_completion", String.valueOf(request.waitForCompletion));
        }
        if (request.allowNoMatch != null) {
            params.put("allow_no_match", String.valueOf(request.allowNoMatch));
        }
        if (request.timeout != null) {
            params.put("timeout", request.timeout._toJsonString());
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, StopTransformResponse._DESERIALIZER);

    private StopTransformRequest(Builder builder) {
        this.allowNoMatch = builder.allowNoMatch;
        this.force = builder.force;
        this.timeout = builder.timeout;
        this.transformId = ApiTypeHelper.requireNonNull(builder.transformId, this, "transformId");
        this.waitForCheckpoint = builder.waitForCheckpoint;
        this.waitForCompletion = builder.waitForCompletion;
    }

    public static StopTransformRequest of(Function<Builder, ObjectBuilder<StopTransformRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Boolean allowNoMatch() {
        return this.allowNoMatch;
    }

    @Nullable
    public final Boolean force() {
        return this.force;
    }

    @Nullable
    public final Time timeout() {
        return this.timeout;
    }

    public final String transformId() {
        return this.transformId;
    }

    @Nullable
    public final Boolean waitForCheckpoint() {
        return this.waitForCheckpoint;
    }

    @Nullable
    public final Boolean waitForCompletion() {
        return this.waitForCompletion;
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<StopTransformRequest> {
        @Nullable
        private Boolean allowNoMatch;
        @Nullable
        private Boolean force;
        @Nullable
        private Time timeout;
        private String transformId;
        @Nullable
        private Boolean waitForCheckpoint;
        @Nullable
        private Boolean waitForCompletion;

        public final Builder allowNoMatch(@Nullable Boolean value) {
            this.allowNoMatch = value;
            return this;
        }

        public final Builder force(@Nullable Boolean value) {
            this.force = value;
            return this;
        }

        public final Builder timeout(@Nullable Time value) {
            this.timeout = value;
            return this;
        }

        public final Builder timeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.timeout(fn.apply(new Time.Builder()).build());
        }

        public final Builder transformId(String value) {
            this.transformId = value;
            return this;
        }

        public final Builder waitForCheckpoint(@Nullable Boolean value) {
            this.waitForCheckpoint = value;
            return this;
        }

        public final Builder waitForCompletion(@Nullable Boolean value) {
            this.waitForCompletion = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public StopTransformRequest build() {
            this._checkSingleUse();
            return new StopTransformRequest(this);
        }
    }
}

