/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.query_dsl;

import co.elastic.clients.elasticsearch._types.TokenPruningConfig;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch._types.query_dsl.QueryBase;
import co.elastic.clients.elasticsearch._types.query_dsl.QueryVariant;
import co.elastic.clients.json.JsonEnum;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.TaggedUnion;
import co.elastic.clients.util.TaggedUnionUtils;
import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class SparseVectorQuery
extends QueryBase
implements TaggedUnion<Kind, Object>,
QueryVariant,
JsonpSerializable {
    private final Kind _kind;
    private final Object _value;
    private final String field;
    @Nullable
    private final String query;
    @Nullable
    private final Boolean prune;
    @Nullable
    private final TokenPruningConfig pruningConfig;
    public static final JsonpDeserializer<SparseVectorQuery> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SparseVectorQuery::setupSparseVectorQueryDeserializer, Builder::build);

    @Override
    public Query.Kind _queryKind() {
        return Query.Kind.SparseVector;
    }

    @Override
    public final Kind _kind() {
        return this._kind;
    }

    @Override
    public final Object _get() {
        return this._value;
    }

    private SparseVectorQuery(Builder builder) {
        super(builder);
        this._kind = ApiTypeHelper.requireNonNull(builder._kind, builder, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(builder._value, builder, "<variant value>");
        this.field = ApiTypeHelper.requireNonNull(builder.field, this, "field");
        this.query = builder.query;
        this.prune = builder.prune;
        this.pruningConfig = builder.pruningConfig;
    }

    public static SparseVectorQuery of(Function<Builder, ObjectBuilder<SparseVectorQuery>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String field() {
        return this.field;
    }

    @Nullable
    public final String query() {
        return this.query;
    }

    @Nullable
    public final Boolean prune() {
        return this.prune;
    }

    @Nullable
    public final TokenPruningConfig pruningConfig() {
        return this.pruningConfig;
    }

    public boolean isQueryVector() {
        return this._kind == Kind.QueryVector;
    }

    public Map<String, Float> queryVector() {
        return (Map)TaggedUnionUtils.get(this, Kind.QueryVector);
    }

    public boolean isInferenceId() {
        return this._kind == Kind.InferenceId;
    }

    public String inferenceId() {
        return (String)TaggedUnionUtils.get(this, Kind.InferenceId);
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        super.serializeInternal(generator, mapper);
        generator.writeKey("field");
        generator.write(this.field);
        if (this.query != null) {
            generator.writeKey("query");
            generator.write(this.query);
        }
        if (this.prune != null) {
            generator.writeKey("prune");
            generator.write(this.prune.booleanValue());
        }
        if (this.pruningConfig != null) {
            generator.writeKey("pruning_config");
            this.pruningConfig.serialize(generator, mapper);
        }
        generator.writeKey(this._kind.jsonValue());
        if (this._value instanceof JsonpSerializable) {
            ((JsonpSerializable)this._value).serialize(generator, mapper);
        } else {
            switch (this._kind) {
                case QueryVector: {
                    generator.writeStartObject();
                    for (Map.Entry item0 : ((Map)this._value).entrySet()) {
                        generator.writeKey((String)item0.getKey());
                        generator.write((double)((Float)item0.getValue()).floatValue());
                    }
                    generator.writeEnd();
                    break;
                }
                case InferenceId: {
                    generator.write((String)this._value);
                }
            }
        }
        generator.writeEnd();
    }

    @Override
    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupSparseVectorQueryDeserializer(ObjectDeserializer<Builder> op) {
        QueryBase.setupQueryBaseDeserializer(op);
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field");
        op.add(Builder::queryVector, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.floatDeserializer()), "query_vector");
        op.add(Builder::inferenceId, JsonpDeserializer.stringDeserializer(), "inference_id");
        op.add(Builder::query, JsonpDeserializer.stringDeserializer(), "query");
        op.add(Builder::prune, JsonpDeserializer.booleanDeserializer(), "prune");
        op.add(Builder::pruningConfig, TokenPruningConfig._DESERIALIZER, "pruning_config");
    }

    public static class Builder
    extends QueryBase.AbstractBuilder<Builder>
    implements ObjectBuilder<SparseVectorQuery> {
        private Kind _kind;
        private Object _value;
        private String field;
        @Nullable
        private String query;
        @Nullable
        private Boolean prune;
        @Nullable
        private TokenPruningConfig pruningConfig;

        public final Builder field(String value) {
            this.field = value;
            return this;
        }

        public final Builder query(@Nullable String value) {
            this.query = value;
            return this;
        }

        public final Builder prune(@Nullable Boolean value) {
            this.prune = value;
            return this;
        }

        public final Builder pruningConfig(@Nullable TokenPruningConfig value) {
            this.pruningConfig = value;
            return this;
        }

        public final Builder pruningConfig(Function<TokenPruningConfig.Builder, ObjectBuilder<TokenPruningConfig>> fn) {
            return this.pruningConfig(fn.apply(new TokenPruningConfig.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        public ContainerBuilder queryVector(Map<String, Float> v) {
            this._kind = Kind.QueryVector;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder inferenceId(String v) {
            this._kind = Kind.InferenceId;
            this._value = v;
            return new ContainerBuilder();
        }

        @Override
        public SparseVectorQuery build() {
            this._checkSingleUse();
            return new SparseVectorQuery(this);
        }

        public class ContainerBuilder
        implements ObjectBuilder<SparseVectorQuery> {
            public final ContainerBuilder field(String value) {
                Builder.this.field = value;
                return this;
            }

            public final ContainerBuilder query(@Nullable String value) {
                Builder.this.query = value;
                return this;
            }

            public final ContainerBuilder prune(@Nullable Boolean value) {
                Builder.this.prune = value;
                return this;
            }

            public final ContainerBuilder pruningConfig(@Nullable TokenPruningConfig value) {
                Builder.this.pruningConfig = value;
                return this;
            }

            public final ContainerBuilder pruningConfig(Function<TokenPruningConfig.Builder, ObjectBuilder<TokenPruningConfig>> fn) {
                return this.pruningConfig(fn.apply(new TokenPruningConfig.Builder()).build());
            }

            @Override
            public SparseVectorQuery build() {
                return Builder.this.build();
            }
        }
    }

    public static enum Kind implements JsonEnum
    {
        QueryVector("query_vector"),
        InferenceId("inference_id");

        private final String jsonValue;

        private Kind(String jsonValue) {
            this.jsonValue = jsonValue;
        }

        @Override
        public String jsonValue() {
            return this.jsonValue;
        }
    }
}

