/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices;

import co.elastic.clients.elasticsearch._types.AcknowledgedResponse;
import co.elastic.clients.elasticsearch.indices.close.CloseIndexResult;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.function.Function;

@JsonpDeserializable
public class CloseIndexResponse
implements AcknowledgedResponse,
JsonpSerializable {
    private final boolean acknowledged;
    private final Map<String, CloseIndexResult> indices;
    private final boolean shardsAcknowledged;
    public static final JsonpDeserializer<CloseIndexResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, CloseIndexResponse::setupCloseIndexResponseDeserializer);

    private CloseIndexResponse(Builder builder) {
        this.acknowledged = ApiTypeHelper.requireNonNull(builder.acknowledged, (Object)this, "acknowledged", false);
        this.indices = ApiTypeHelper.unmodifiableRequired(builder.indices, (Object)this, "indices");
        this.shardsAcknowledged = ApiTypeHelper.requireNonNull(builder.shardsAcknowledged, (Object)this, "shardsAcknowledged", false);
    }

    public static CloseIndexResponse of(Function<Builder, ObjectBuilder<CloseIndexResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public final boolean acknowledged() {
        return this.acknowledged;
    }

    public final Map<String, CloseIndexResult> indices() {
        return this.indices;
    }

    public final boolean shardsAcknowledged() {
        return this.shardsAcknowledged;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("acknowledged");
        generator.write(this.acknowledged);
        if (ApiTypeHelper.isDefined(this.indices)) {
            generator.writeKey("indices");
            generator.writeStartObject();
            for (Map.Entry<String, CloseIndexResult> item0 : this.indices.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        generator.writeKey("shards_acknowledged");
        generator.write(this.shardsAcknowledged);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupCloseIndexResponseDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::acknowledged, JsonpDeserializer.booleanDeserializer(), "acknowledged");
        op.add(Builder::indices, JsonpDeserializer.stringMapDeserializer(CloseIndexResult._DESERIALIZER), "indices");
        op.add(Builder::shardsAcknowledged, JsonpDeserializer.booleanDeserializer(), "shards_acknowledged");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<CloseIndexResponse> {
        private Boolean acknowledged;
        private Map<String, CloseIndexResult> indices;
        private Boolean shardsAcknowledged;

        public final Builder acknowledged(boolean value) {
            this.acknowledged = value;
            return this;
        }

        public final Builder indices(Map<String, CloseIndexResult> map) {
            this.indices = Builder._mapPutAll(this.indices, map);
            return this;
        }

        public final Builder indices(String key, CloseIndexResult value) {
            this.indices = Builder._mapPut(this.indices, key, value);
            return this;
        }

        public final Builder indices(String key, Function<CloseIndexResult.Builder, ObjectBuilder<CloseIndexResult>> fn) {
            return this.indices(key, fn.apply(new CloseIndexResult.Builder()).build());
        }

        public final Builder shardsAcknowledged(boolean value) {
            this.shardsAcknowledged = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public CloseIndexResponse build() {
            this._checkSingleUse();
            return new CloseIndexResponse(this);
        }
    }
}

