/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.search_application;

import co.elastic.clients.elasticsearch.search_application.SearchApplicationTemplate;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class SearchApplication
implements JsonpSerializable {
    private final String name;
    private final List<String> indices;
    private final long updatedAtMillis;
    @Nullable
    private final String analyticsCollectionName;
    @Nullable
    private final SearchApplicationTemplate template;
    public static final JsonpDeserializer<SearchApplication> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SearchApplication::setupSearchApplicationDeserializer);

    protected SearchApplication(AbstractBuilder<?> builder) {
        this.name = ApiTypeHelper.requireNonNull(((AbstractBuilder)builder).name, this, "name");
        this.indices = ApiTypeHelper.unmodifiableRequired(((AbstractBuilder)builder).indices, (Object)this, "indices");
        this.updatedAtMillis = ApiTypeHelper.requireNonNull(((AbstractBuilder)builder).updatedAtMillis, (Object)this, "updatedAtMillis", 0L);
        this.analyticsCollectionName = ((AbstractBuilder)builder).analyticsCollectionName;
        this.template = ((AbstractBuilder)builder).template;
    }

    public static SearchApplication searchApplicationOf(Function<Builder, ObjectBuilder<SearchApplication>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String name() {
        return this.name;
    }

    public final List<String> indices() {
        return this.indices;
    }

    public final long updatedAtMillis() {
        return this.updatedAtMillis;
    }

    @Nullable
    public final String analyticsCollectionName() {
        return this.analyticsCollectionName;
    }

    @Nullable
    public final SearchApplicationTemplate template() {
        return this.template;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("name");
        generator.write(this.name);
        if (ApiTypeHelper.isDefined(this.indices)) {
            generator.writeKey("indices");
            generator.writeStartArray();
            for (String item0 : this.indices) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        generator.writeKey("updated_at_millis");
        generator.write(this.updatedAtMillis);
        if (this.analyticsCollectionName != null) {
            generator.writeKey("analytics_collection_name");
            generator.write(this.analyticsCollectionName);
        }
        if (this.template != null) {
            generator.writeKey("template");
            this.template.serialize(generator, mapper);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static <BuilderT extends AbstractBuilder<BuilderT>> void setupSearchApplicationDeserializer(ObjectDeserializer<BuilderT> op) {
        op.add(AbstractBuilder::name, JsonpDeserializer.stringDeserializer(), "name");
        op.add(AbstractBuilder::indices, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "indices");
        op.add(AbstractBuilder::updatedAtMillis, JsonpDeserializer.longDeserializer(), "updated_at_millis");
        op.add(AbstractBuilder::analyticsCollectionName, JsonpDeserializer.stringDeserializer(), "analytics_collection_name");
        op.add(AbstractBuilder::template, SearchApplicationTemplate._DESERIALIZER, "template");
    }

    public static abstract class AbstractBuilder<BuilderT extends AbstractBuilder<BuilderT>>
    extends WithJsonObjectBuilderBase<BuilderT> {
        private String name;
        private List<String> indices;
        private Long updatedAtMillis;
        @Nullable
        private String analyticsCollectionName;
        @Nullable
        private SearchApplicationTemplate template;

        public final BuilderT name(String value) {
            this.name = value;
            return (BuilderT)this.self();
        }

        public final BuilderT indices(List<String> list) {
            this.indices = AbstractBuilder._listAddAll(this.indices, list);
            return (BuilderT)this.self();
        }

        public final BuilderT indices(String value, String ... values) {
            this.indices = AbstractBuilder._listAdd(this.indices, value, values);
            return (BuilderT)this.self();
        }

        public final BuilderT updatedAtMillis(long value) {
            this.updatedAtMillis = value;
            return (BuilderT)this.self();
        }

        public final BuilderT analyticsCollectionName(@Nullable String value) {
            this.analyticsCollectionName = value;
            return (BuilderT)this.self();
        }

        public final BuilderT template(@Nullable SearchApplicationTemplate value) {
            this.template = value;
            return (BuilderT)this.self();
        }

        public final BuilderT template(Function<SearchApplicationTemplate.Builder, ObjectBuilder<SearchApplicationTemplate>> fn) {
            return this.template(fn.apply(new SearchApplicationTemplate.Builder()).build());
        }

        @Override
        protected abstract BuilderT self();
    }

    public static class Builder
    extends AbstractBuilder<Builder>
    implements ObjectBuilder<SearchApplication> {
        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public SearchApplication build() {
            this._checkSingleUse();
            return new SearchApplication(this);
        }
    }
}

