/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch.ml.InferenceConfigUpdate;
import co.elastic.clients.elasticsearch.ml.InferenceConfigUpdateVariant;
import co.elastic.clients.elasticsearch.ml.NlpTokenizationUpdateOptions;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class TextEmbeddingInferenceUpdateOptions
implements InferenceConfigUpdateVariant,
JsonpSerializable {
    @Nullable
    private final NlpTokenizationUpdateOptions tokenization;
    @Nullable
    private final String resultsField;
    public static final JsonpDeserializer<TextEmbeddingInferenceUpdateOptions> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, TextEmbeddingInferenceUpdateOptions::setupTextEmbeddingInferenceUpdateOptionsDeserializer);

    private TextEmbeddingInferenceUpdateOptions(Builder builder) {
        this.tokenization = builder.tokenization;
        this.resultsField = builder.resultsField;
    }

    public static TextEmbeddingInferenceUpdateOptions of(Function<Builder, ObjectBuilder<TextEmbeddingInferenceUpdateOptions>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public InferenceConfigUpdate.Kind _inferenceConfigUpdateKind() {
        return InferenceConfigUpdate.Kind.TextEmbedding;
    }

    @Nullable
    public final NlpTokenizationUpdateOptions tokenization() {
        return this.tokenization;
    }

    @Nullable
    public final String resultsField() {
        return this.resultsField;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.tokenization != null) {
            generator.writeKey("tokenization");
            this.tokenization.serialize(generator, mapper);
        }
        if (this.resultsField != null) {
            generator.writeKey("results_field");
            generator.write(this.resultsField);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupTextEmbeddingInferenceUpdateOptionsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::tokenization, NlpTokenizationUpdateOptions._DESERIALIZER, "tokenization");
        op.add(Builder::resultsField, JsonpDeserializer.stringDeserializer(), "results_field");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<TextEmbeddingInferenceUpdateOptions> {
        @Nullable
        private NlpTokenizationUpdateOptions tokenization;
        @Nullable
        private String resultsField;

        public final Builder tokenization(@Nullable NlpTokenizationUpdateOptions value) {
            this.tokenization = value;
            return this;
        }

        public final Builder tokenization(Function<NlpTokenizationUpdateOptions.Builder, ObjectBuilder<NlpTokenizationUpdateOptions>> fn) {
            return this.tokenization(fn.apply(new NlpTokenizationUpdateOptions.Builder()).build());
        }

        public final Builder resultsField(@Nullable String value) {
            this.resultsField = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public TextEmbeddingInferenceUpdateOptions build() {
            this._checkSingleUse();
            return new TextEmbeddingInferenceUpdateOptions(this);
        }
    }
}

