/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.ml.GetCalendarsResponse;
import co.elastic.clients.elasticsearch.ml.Page;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class GetCalendarsRequest
extends RequestBase
implements JsonpSerializable {
    @Nullable
    private final String calendarId;
    @Nullable
    private final Integer from;
    @Nullable
    private final Page page;
    @Nullable
    private final Integer size;
    public static final JsonpDeserializer<GetCalendarsRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GetCalendarsRequest::setupGetCalendarsRequestDeserializer);
    public static final Endpoint<GetCalendarsRequest, GetCalendarsResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<GetCalendarsRequest, GetCalendarsResponse>("es/ml.get_calendars", request -> "POST", request -> {
        boolean _calendarId = true;
        boolean propsSet = false;
        if (request.calendarId() != null) {
            propsSet |= true;
        }
        if (!propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_ml");
            buf.append("/calendars");
            return buf.toString();
        }
        if (propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_ml");
            buf.append("/calendars");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.calendarId, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        boolean _calendarId = true;
        boolean propsSet = false;
        if (request.calendarId() != null) {
            propsSet |= true;
        }
        if (!propsSet) {
            // empty if block
        }
        if (propsSet) {
            params.put("calendarId", request.calendarId);
        }
        return params;
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.size != null) {
            params.put("size", String.valueOf(request.size));
        }
        if (request.from != null) {
            params.put("from", String.valueOf(request.from));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, GetCalendarsResponse._DESERIALIZER);

    private GetCalendarsRequest(Builder builder) {
        this.calendarId = builder.calendarId;
        this.from = builder.from;
        this.page = builder.page;
        this.size = builder.size;
    }

    public static GetCalendarsRequest of(Function<Builder, ObjectBuilder<GetCalendarsRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String calendarId() {
        return this.calendarId;
    }

    @Nullable
    public final Integer from() {
        return this.from;
    }

    @Nullable
    public final Page page() {
        return this.page;
    }

    @Nullable
    public final Integer size() {
        return this.size;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.page != null) {
            generator.writeKey("page");
            this.page.serialize(generator, mapper);
        }
    }

    protected static void setupGetCalendarsRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::page, Page._DESERIALIZER, "page");
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<GetCalendarsRequest> {
        @Nullable
        private String calendarId;
        @Nullable
        private Integer from;
        @Nullable
        private Page page;
        @Nullable
        private Integer size;

        public final Builder calendarId(@Nullable String value) {
            this.calendarId = value;
            return this;
        }

        public final Builder from(@Nullable Integer value) {
            this.from = value;
            return this;
        }

        public final Builder page(@Nullable Page value) {
            this.page = value;
            return this;
        }

        public final Builder page(Function<Page.Builder, ObjectBuilder<Page>> fn) {
            return this.page(fn.apply(new Page.Builder()).build());
        }

        public final Builder size(@Nullable Integer value) {
            this.size = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public GetCalendarsRequest build() {
            this._checkSingleUse();
            return new GetCalendarsRequest(this);
        }
    }
}

