/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ingest;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class Redact
implements JsonpSerializable {
    private final boolean isRedacted;
    public static final JsonpDeserializer<Redact> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Redact::setupRedactDeserializer);

    private Redact(Builder builder) {
        this.isRedacted = ApiTypeHelper.requireNonNull(builder.isRedacted, this, "isRedacted");
    }

    public static Redact of(Function<Builder, ObjectBuilder<Redact>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final boolean isRedacted() {
        return this.isRedacted;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("_is_redacted");
        generator.write(this.isRedacted);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupRedactDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::isRedacted, JsonpDeserializer.booleanDeserializer(), "_is_redacted");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<Redact> {
        private Boolean isRedacted;

        public final Builder isRedacted(boolean value) {
            this.isRedacted = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public Redact build() {
            this._checkSingleUse();
            return new Redact(this);
        }
    }
}

