/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.eql;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.ExpandWildcard;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch._types.mapping.RuntimeField;
import co.elastic.clients.elasticsearch._types.query_dsl.FieldAndFormat;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch._types.query_dsl.QueryVariant;
import co.elastic.clients.elasticsearch.eql.EqlSearchResponse;
import co.elastic.clients.elasticsearch.eql.search.ResultPosition;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

@JsonpDeserializable
public class EqlSearchRequest
extends RequestBase
implements JsonpSerializable {
    @Nullable
    private final Boolean allowNoIndices;
    @Nullable
    private final Boolean caseSensitive;
    @Nullable
    private final String eventCategoryField;
    private final List<ExpandWildcard> expandWildcards;
    @Nullable
    private final Number fetchSize;
    private final List<FieldAndFormat> fields;
    private final List<Query> filter;
    @Nullable
    private final Boolean ignoreUnavailable;
    private final List<String> index;
    @Nullable
    private final Time keepAlive;
    @Nullable
    private final Boolean keepOnCompletion;
    private final String query;
    @Nullable
    private final ResultPosition resultPosition;
    private final Map<String, RuntimeField> runtimeMappings;
    @Nullable
    private final Number size;
    @Nullable
    private final String tiebreakerField;
    @Nullable
    private final String timestampField;
    @Nullable
    private final Time waitForCompletionTimeout;
    public static final JsonpDeserializer<EqlSearchRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, EqlSearchRequest::setupEqlSearchRequestDeserializer);
    public static final SimpleEndpoint<EqlSearchRequest, ?> _ENDPOINT = new SimpleEndpoint<EqlSearchRequest, EqlSearchResponse<Object>>("es/eql.search", request -> "POST", request -> {
        boolean _index = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/");
            SimpleEndpoint.pathEncode(request.index.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            buf.append("/_eql");
            buf.append("/search");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        boolean _index = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            params.put("index", request.index.stream().map(v -> v).collect(Collectors.joining(",")));
        }
        return params;
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (ApiTypeHelper.isDefined(request.expandWildcards)) {
            params.put("expand_wildcards", request.expandWildcards.stream().map(v -> v.jsonValue()).collect(Collectors.joining(",")));
        }
        if (request.ignoreUnavailable != null) {
            params.put("ignore_unavailable", String.valueOf(request.ignoreUnavailable));
        }
        if (request.allowNoIndices != null) {
            params.put("allow_no_indices", String.valueOf(request.allowNoIndices));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, EqlSearchResponse._DESERIALIZER);

    private EqlSearchRequest(Builder builder) {
        this.allowNoIndices = builder.allowNoIndices;
        this.caseSensitive = builder.caseSensitive;
        this.eventCategoryField = builder.eventCategoryField;
        this.expandWildcards = ApiTypeHelper.unmodifiable(builder.expandWildcards);
        this.fetchSize = builder.fetchSize;
        this.fields = ApiTypeHelper.unmodifiable(builder.fields);
        this.filter = ApiTypeHelper.unmodifiable(builder.filter);
        this.ignoreUnavailable = builder.ignoreUnavailable;
        this.index = ApiTypeHelper.unmodifiableRequired(builder.index, (Object)this, "index");
        this.keepAlive = builder.keepAlive;
        this.keepOnCompletion = builder.keepOnCompletion;
        this.query = ApiTypeHelper.requireNonNull(builder.query, this, "query");
        this.resultPosition = builder.resultPosition;
        this.runtimeMappings = ApiTypeHelper.unmodifiable(builder.runtimeMappings);
        this.size = builder.size;
        this.tiebreakerField = builder.tiebreakerField;
        this.timestampField = builder.timestampField;
        this.waitForCompletionTimeout = builder.waitForCompletionTimeout;
    }

    public static EqlSearchRequest of(Function<Builder, ObjectBuilder<EqlSearchRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Boolean allowNoIndices() {
        return this.allowNoIndices;
    }

    @Nullable
    public final Boolean caseSensitive() {
        return this.caseSensitive;
    }

    @Nullable
    public final String eventCategoryField() {
        return this.eventCategoryField;
    }

    public final List<ExpandWildcard> expandWildcards() {
        return this.expandWildcards;
    }

    @Nullable
    public final Number fetchSize() {
        return this.fetchSize;
    }

    public final List<FieldAndFormat> fields() {
        return this.fields;
    }

    public final List<Query> filter() {
        return this.filter;
    }

    @Nullable
    public final Boolean ignoreUnavailable() {
        return this.ignoreUnavailable;
    }

    public final List<String> index() {
        return this.index;
    }

    @Nullable
    public final Time keepAlive() {
        return this.keepAlive;
    }

    @Nullable
    public final Boolean keepOnCompletion() {
        return this.keepOnCompletion;
    }

    public final String query() {
        return this.query;
    }

    @Nullable
    public final ResultPosition resultPosition() {
        return this.resultPosition;
    }

    public final Map<String, RuntimeField> runtimeMappings() {
        return this.runtimeMappings;
    }

    @Nullable
    public final Number size() {
        return this.size;
    }

    @Nullable
    public final String tiebreakerField() {
        return this.tiebreakerField;
    }

    @Nullable
    public final String timestampField() {
        return this.timestampField;
    }

    @Nullable
    public final Time waitForCompletionTimeout() {
        return this.waitForCompletionTimeout;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.caseSensitive != null) {
            generator.writeKey("case_sensitive");
            generator.write(this.caseSensitive.booleanValue());
        }
        if (this.eventCategoryField != null) {
            generator.writeKey("event_category_field");
            generator.write(this.eventCategoryField);
        }
        if (this.fetchSize != null) {
            generator.writeKey("fetch_size");
            generator.write(this.fetchSize.doubleValue());
        }
        if (ApiTypeHelper.isDefined(this.fields)) {
            generator.writeKey("fields");
            generator.writeStartArray();
            for (FieldAndFormat fieldAndFormat : this.fields) {
                fieldAndFormat.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.filter)) {
            generator.writeKey("filter");
            generator.writeStartArray();
            for (Query query : this.filter) {
                query.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.keepAlive != null) {
            generator.writeKey("keep_alive");
            this.keepAlive.serialize(generator, mapper);
        }
        if (this.keepOnCompletion != null) {
            generator.writeKey("keep_on_completion");
            generator.write(this.keepOnCompletion.booleanValue());
        }
        generator.writeKey("query");
        generator.write(this.query);
        if (this.resultPosition != null) {
            generator.writeKey("result_position");
            this.resultPosition.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.runtimeMappings)) {
            generator.writeKey("runtime_mappings");
            generator.writeStartObject();
            for (Map.Entry entry : this.runtimeMappings.entrySet()) {
                generator.writeKey((String)entry.getKey());
                ((RuntimeField)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.size != null) {
            generator.writeKey("size");
            generator.write(this.size.doubleValue());
        }
        if (this.tiebreakerField != null) {
            generator.writeKey("tiebreaker_field");
            generator.write(this.tiebreakerField);
        }
        if (this.timestampField != null) {
            generator.writeKey("timestamp_field");
            generator.write(this.timestampField);
        }
        if (this.waitForCompletionTimeout != null) {
            generator.writeKey("wait_for_completion_timeout");
            this.waitForCompletionTimeout.serialize(generator, mapper);
        }
    }

    protected static void setupEqlSearchRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::caseSensitive, JsonpDeserializer.booleanDeserializer(), "case_sensitive");
        op.add(Builder::eventCategoryField, JsonpDeserializer.stringDeserializer(), "event_category_field");
        op.add(Builder::fetchSize, JsonpDeserializer.numberDeserializer(), "fetch_size");
        op.add(Builder::fields, JsonpDeserializer.arrayDeserializer(FieldAndFormat._DESERIALIZER), "fields");
        op.add(Builder::filter, JsonpDeserializer.arrayDeserializer(Query._DESERIALIZER), "filter");
        op.add(Builder::keepAlive, Time._DESERIALIZER, "keep_alive");
        op.add(Builder::keepOnCompletion, JsonpDeserializer.booleanDeserializer(), "keep_on_completion");
        op.add(Builder::query, JsonpDeserializer.stringDeserializer(), "query");
        op.add(Builder::resultPosition, ResultPosition._DESERIALIZER, "result_position");
        op.add(Builder::runtimeMappings, JsonpDeserializer.stringMapDeserializer(RuntimeField._DESERIALIZER), "runtime_mappings");
        op.add(Builder::size, JsonpDeserializer.numberDeserializer(), "size");
        op.add(Builder::tiebreakerField, JsonpDeserializer.stringDeserializer(), "tiebreaker_field");
        op.add(Builder::timestampField, JsonpDeserializer.stringDeserializer(), "timestamp_field");
        op.add(Builder::waitForCompletionTimeout, Time._DESERIALIZER, "wait_for_completion_timeout");
    }

    public static <TEvent> Endpoint<EqlSearchRequest, EqlSearchResponse<TEvent>, ErrorResponse> createSearchEndpoint(JsonpDeserializer<TEvent> tEventDeserializer) {
        return _ENDPOINT.withResponseDeserializer(EqlSearchResponse.createEqlSearchResponseDeserializer(tEventDeserializer));
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<EqlSearchRequest> {
        @Nullable
        private Boolean allowNoIndices;
        @Nullable
        private Boolean caseSensitive;
        @Nullable
        private String eventCategoryField;
        @Nullable
        private List<ExpandWildcard> expandWildcards;
        @Nullable
        private Number fetchSize;
        @Nullable
        private List<FieldAndFormat> fields;
        @Nullable
        private List<Query> filter;
        @Nullable
        private Boolean ignoreUnavailable;
        private List<String> index;
        @Nullable
        private Time keepAlive;
        @Nullable
        private Boolean keepOnCompletion;
        private String query;
        @Nullable
        private ResultPosition resultPosition;
        @Nullable
        private Map<String, RuntimeField> runtimeMappings;
        @Nullable
        private Number size;
        @Nullable
        private String tiebreakerField;
        @Nullable
        private String timestampField;
        @Nullable
        private Time waitForCompletionTimeout;

        public final Builder allowNoIndices(@Nullable Boolean value) {
            this.allowNoIndices = value;
            return this;
        }

        public final Builder caseSensitive(@Nullable Boolean value) {
            this.caseSensitive = value;
            return this;
        }

        public final Builder eventCategoryField(@Nullable String value) {
            this.eventCategoryField = value;
            return this;
        }

        public final Builder expandWildcards(List<ExpandWildcard> list) {
            this.expandWildcards = Builder._listAddAll(this.expandWildcards, list);
            return this;
        }

        public final Builder expandWildcards(ExpandWildcard value, ExpandWildcard ... values) {
            this.expandWildcards = Builder._listAdd(this.expandWildcards, value, values);
            return this;
        }

        public final Builder fetchSize(@Nullable Number value) {
            this.fetchSize = value;
            return this;
        }

        public final Builder fields(List<FieldAndFormat> list) {
            this.fields = Builder._listAddAll(this.fields, list);
            return this;
        }

        public final Builder fields(FieldAndFormat value, FieldAndFormat ... values) {
            this.fields = Builder._listAdd(this.fields, value, values);
            return this;
        }

        public final Builder fields(Function<FieldAndFormat.Builder, ObjectBuilder<FieldAndFormat>> fn) {
            return this.fields(fn.apply(new FieldAndFormat.Builder()).build(), new FieldAndFormat[0]);
        }

        public final Builder filter(List<Query> list) {
            this.filter = Builder._listAddAll(this.filter, list);
            return this;
        }

        public final Builder filter(Query value, Query ... values) {
            this.filter = Builder._listAdd(this.filter, value, values);
            return this;
        }

        public final Builder filter(QueryVariant value, QueryVariant ... values) {
            this.filter = Builder._listAdd(this.filter, value._toQuery(), new Query[0]);
            for (QueryVariant v : values) {
                Builder._listAdd(this.filter, v._toQuery(), new Query[0]);
            }
            return this;
        }

        public final Builder filter(Function<Query.Builder, ObjectBuilder<Query>> fn) {
            return this.filter(fn.apply(new Query.Builder()).build(), new Query[0]);
        }

        public final Builder ignoreUnavailable(@Nullable Boolean value) {
            this.ignoreUnavailable = value;
            return this;
        }

        public final Builder index(List<String> list) {
            this.index = Builder._listAddAll(this.index, list);
            return this;
        }

        public final Builder index(String value, String ... values) {
            this.index = Builder._listAdd(this.index, value, values);
            return this;
        }

        public final Builder keepAlive(@Nullable Time value) {
            this.keepAlive = value;
            return this;
        }

        public final Builder keepAlive(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.keepAlive(fn.apply(new Time.Builder()).build());
        }

        public final Builder keepOnCompletion(@Nullable Boolean value) {
            this.keepOnCompletion = value;
            return this;
        }

        public final Builder query(String value) {
            this.query = value;
            return this;
        }

        public final Builder resultPosition(@Nullable ResultPosition value) {
            this.resultPosition = value;
            return this;
        }

        public final Builder runtimeMappings(Map<String, RuntimeField> map) {
            this.runtimeMappings = Builder._mapPutAll(this.runtimeMappings, map);
            return this;
        }

        public final Builder runtimeMappings(String key, RuntimeField value) {
            this.runtimeMappings = Builder._mapPut(this.runtimeMappings, key, value);
            return this;
        }

        public final Builder runtimeMappings(String key, Function<RuntimeField.Builder, ObjectBuilder<RuntimeField>> fn) {
            return this.runtimeMappings(key, fn.apply(new RuntimeField.Builder()).build());
        }

        public final Builder size(@Nullable Number value) {
            this.size = value;
            return this;
        }

        public final Builder tiebreakerField(@Nullable String value) {
            this.tiebreakerField = value;
            return this;
        }

        public final Builder timestampField(@Nullable String value) {
            this.timestampField = value;
            return this;
        }

        public final Builder waitForCompletionTimeout(@Nullable Time value) {
            this.waitForCompletionTimeout = value;
            return this;
        }

        public final Builder waitForCompletionTimeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.waitForCompletionTimeout(fn.apply(new Time.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public EqlSearchRequest build() {
            this._checkSingleUse();
            return new EqlSearchRequest(this);
        }
    }
}

