/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.mapping;

import co.elastic.clients.elasticsearch._types.mapping.DynamicTemplateVariant;
import co.elastic.clients.elasticsearch._types.mapping.MatchType;
import co.elastic.clients.elasticsearch._types.mapping.Property;
import co.elastic.clients.json.JsonEnum;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.TaggedUnion;
import co.elastic.clients.util.TaggedUnionUtils;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class DynamicTemplate
implements TaggedUnion<Kind, Object>,
JsonpSerializable {
    private final Kind _kind;
    private final Object _value;
    private final List<String> match;
    private final List<String> pathMatch;
    private final List<String> unmatch;
    private final List<String> pathUnmatch;
    private final List<String> matchMappingType;
    private final List<String> unmatchMappingType;
    @Nullable
    private final MatchType matchPattern;
    public static final JsonpDeserializer<DynamicTemplate> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DynamicTemplate::setupDynamicTemplateDeserializer, Builder::build);

    @Override
    public final Kind _kind() {
        return this._kind;
    }

    @Override
    public final Object _get() {
        return this._value;
    }

    public DynamicTemplate(DynamicTemplateVariant value) {
        this._kind = ApiTypeHelper.requireNonNull(value._dynamicTemplateKind(), this, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(value, this, "<variant value>");
        this.match = null;
        this.pathMatch = null;
        this.unmatch = null;
        this.pathUnmatch = null;
        this.matchMappingType = null;
        this.unmatchMappingType = null;
        this.matchPattern = null;
    }

    private DynamicTemplate(Builder builder) {
        this._kind = ApiTypeHelper.requireNonNull(builder._kind, builder, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(builder._value, builder, "<variant value>");
        this.match = ApiTypeHelper.unmodifiable(builder.match);
        this.pathMatch = ApiTypeHelper.unmodifiable(builder.pathMatch);
        this.unmatch = ApiTypeHelper.unmodifiable(builder.unmatch);
        this.pathUnmatch = ApiTypeHelper.unmodifiable(builder.pathUnmatch);
        this.matchMappingType = ApiTypeHelper.unmodifiable(builder.matchMappingType);
        this.unmatchMappingType = ApiTypeHelper.unmodifiable(builder.unmatchMappingType);
        this.matchPattern = builder.matchPattern;
    }

    public static DynamicTemplate of(Function<Builder, ObjectBuilder<DynamicTemplate>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<String> match() {
        return this.match;
    }

    public final List<String> pathMatch() {
        return this.pathMatch;
    }

    public final List<String> unmatch() {
        return this.unmatch;
    }

    public final List<String> pathUnmatch() {
        return this.pathUnmatch;
    }

    public final List<String> matchMappingType() {
        return this.matchMappingType;
    }

    public final List<String> unmatchMappingType() {
        return this.unmatchMappingType;
    }

    @Nullable
    public final MatchType matchPattern() {
        return this.matchPattern;
    }

    public boolean isMapping() {
        return this._kind == Kind.Mapping;
    }

    public Property mapping() {
        return (Property)TaggedUnionUtils.get(this, Kind.Mapping);
    }

    public boolean isRuntime() {
        return this._kind == Kind.Runtime;
    }

    public Property runtime() {
        return (Property)TaggedUnionUtils.get(this, Kind.Runtime);
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        if (ApiTypeHelper.isDefined(this.match)) {
            generator.writeKey("match");
            generator.writeStartArray();
            for (String item0 : this.match) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.pathMatch)) {
            generator.writeKey("path_match");
            generator.writeStartArray();
            for (String item0 : this.pathMatch) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.unmatch)) {
            generator.writeKey("unmatch");
            generator.writeStartArray();
            for (String item0 : this.unmatch) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.pathUnmatch)) {
            generator.writeKey("path_unmatch");
            generator.writeStartArray();
            for (String item0 : this.pathUnmatch) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.matchMappingType)) {
            generator.writeKey("match_mapping_type");
            generator.writeStartArray();
            for (String item0 : this.matchMappingType) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.unmatchMappingType)) {
            generator.writeKey("unmatch_mapping_type");
            generator.writeStartArray();
            for (String item0 : this.unmatchMappingType) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (this.matchPattern != null) {
            generator.writeKey("match_pattern");
            this.matchPattern.serialize(generator, mapper);
        }
        generator.writeKey(this._kind.jsonValue());
        if (this._value instanceof JsonpSerializable) {
            ((JsonpSerializable)this._value).serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupDynamicTemplateDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::mapping, Property._DESERIALIZER, "mapping");
        op.add(Builder::runtime, Property._DESERIALIZER, "runtime");
        op.add(Builder::match, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "match");
        op.add(Builder::pathMatch, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "path_match");
        op.add(Builder::unmatch, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "unmatch");
        op.add(Builder::pathUnmatch, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "path_unmatch");
        op.add(Builder::matchMappingType, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "match_mapping_type");
        op.add(Builder::unmatchMappingType, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "unmatch_mapping_type");
        op.add(Builder::matchPattern, MatchType._DESERIALIZER, "match_pattern");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<DynamicTemplate> {
        private Kind _kind;
        private Object _value;
        @Nullable
        private List<String> match;
        @Nullable
        private List<String> pathMatch;
        @Nullable
        private List<String> unmatch;
        @Nullable
        private List<String> pathUnmatch;
        @Nullable
        private List<String> matchMappingType;
        @Nullable
        private List<String> unmatchMappingType;
        @Nullable
        private MatchType matchPattern;

        public final Builder match(List<String> list) {
            this.match = Builder._listAddAll(this.match, list);
            return this;
        }

        public final Builder match(String value, String ... values) {
            this.match = Builder._listAdd(this.match, value, values);
            return this;
        }

        public final Builder pathMatch(List<String> list) {
            this.pathMatch = Builder._listAddAll(this.pathMatch, list);
            return this;
        }

        public final Builder pathMatch(String value, String ... values) {
            this.pathMatch = Builder._listAdd(this.pathMatch, value, values);
            return this;
        }

        public final Builder unmatch(List<String> list) {
            this.unmatch = Builder._listAddAll(this.unmatch, list);
            return this;
        }

        public final Builder unmatch(String value, String ... values) {
            this.unmatch = Builder._listAdd(this.unmatch, value, values);
            return this;
        }

        public final Builder pathUnmatch(List<String> list) {
            this.pathUnmatch = Builder._listAddAll(this.pathUnmatch, list);
            return this;
        }

        public final Builder pathUnmatch(String value, String ... values) {
            this.pathUnmatch = Builder._listAdd(this.pathUnmatch, value, values);
            return this;
        }

        public final Builder matchMappingType(List<String> list) {
            this.matchMappingType = Builder._listAddAll(this.matchMappingType, list);
            return this;
        }

        public final Builder matchMappingType(String value, String ... values) {
            this.matchMappingType = Builder._listAdd(this.matchMappingType, value, values);
            return this;
        }

        public final Builder unmatchMappingType(List<String> list) {
            this.unmatchMappingType = Builder._listAddAll(this.unmatchMappingType, list);
            return this;
        }

        public final Builder unmatchMappingType(String value, String ... values) {
            this.unmatchMappingType = Builder._listAdd(this.unmatchMappingType, value, values);
            return this;
        }

        public final Builder matchPattern(@Nullable MatchType value) {
            this.matchPattern = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        public ContainerBuilder mapping(Property v) {
            this._kind = Kind.Mapping;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder mapping(Function<Property.Builder, ObjectBuilder<Property>> fn) {
            return this.mapping(fn.apply(new Property.Builder()).build());
        }

        public ContainerBuilder runtime(Property v) {
            this._kind = Kind.Runtime;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder runtime(Function<Property.Builder, ObjectBuilder<Property>> fn) {
            return this.runtime(fn.apply(new Property.Builder()).build());
        }

        @Override
        public DynamicTemplate build() {
            this._checkSingleUse();
            return new DynamicTemplate(this);
        }

        public class ContainerBuilder
        implements ObjectBuilder<DynamicTemplate> {
            public final ContainerBuilder match(List<String> list) {
                Builder.this.match = Builder._listAddAll(Builder.this.match, list);
                return this;
            }

            public final ContainerBuilder match(String value, String ... values) {
                Builder.this.match = Builder._listAdd(Builder.this.match, value, values);
                return this;
            }

            public final ContainerBuilder pathMatch(List<String> list) {
                Builder.this.pathMatch = Builder._listAddAll(Builder.this.pathMatch, list);
                return this;
            }

            public final ContainerBuilder pathMatch(String value, String ... values) {
                Builder.this.pathMatch = Builder._listAdd(Builder.this.pathMatch, value, values);
                return this;
            }

            public final ContainerBuilder unmatch(List<String> list) {
                Builder.this.unmatch = Builder._listAddAll(Builder.this.unmatch, list);
                return this;
            }

            public final ContainerBuilder unmatch(String value, String ... values) {
                Builder.this.unmatch = Builder._listAdd(Builder.this.unmatch, value, values);
                return this;
            }

            public final ContainerBuilder pathUnmatch(List<String> list) {
                Builder.this.pathUnmatch = Builder._listAddAll(Builder.this.pathUnmatch, list);
                return this;
            }

            public final ContainerBuilder pathUnmatch(String value, String ... values) {
                Builder.this.pathUnmatch = Builder._listAdd(Builder.this.pathUnmatch, value, values);
                return this;
            }

            public final ContainerBuilder matchMappingType(List<String> list) {
                Builder.this.matchMappingType = Builder._listAddAll(Builder.this.matchMappingType, list);
                return this;
            }

            public final ContainerBuilder matchMappingType(String value, String ... values) {
                Builder.this.matchMappingType = Builder._listAdd(Builder.this.matchMappingType, value, values);
                return this;
            }

            public final ContainerBuilder unmatchMappingType(List<String> list) {
                Builder.this.unmatchMappingType = Builder._listAddAll(Builder.this.unmatchMappingType, list);
                return this;
            }

            public final ContainerBuilder unmatchMappingType(String value, String ... values) {
                Builder.this.unmatchMappingType = Builder._listAdd(Builder.this.unmatchMappingType, value, values);
                return this;
            }

            public final ContainerBuilder matchPattern(@Nullable MatchType value) {
                Builder.this.matchPattern = value;
                return this;
            }

            @Override
            public DynamicTemplate build() {
                return Builder.this.build();
            }
        }
    }

    public static enum Kind implements JsonEnum
    {
        Mapping("mapping"),
        Runtime("runtime");

        private final String jsonValue;

        private Kind(String jsonValue) {
            this.jsonValue = jsonValue;
        }

        @Override
        public String jsonValue() {
            return this.jsonValue;
        }
    }
}

