/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.inference;

import co.elastic.clients.ApiClient;
import co.elastic.clients.elasticsearch._types.ElasticsearchException;
import co.elastic.clients.elasticsearch.inference.DeleteModelRequest;
import co.elastic.clients.elasticsearch.inference.DeleteModelResponse;
import co.elastic.clients.elasticsearch.inference.GetModelRequest;
import co.elastic.clients.elasticsearch.inference.GetModelResponse;
import co.elastic.clients.elasticsearch.inference.InferenceRequest;
import co.elastic.clients.elasticsearch.inference.InferenceResponse;
import co.elastic.clients.elasticsearch.inference.PutModelRequest;
import co.elastic.clients.elasticsearch.inference.PutModelResponse;
import co.elastic.clients.transport.ElasticsearchTransport;
import co.elastic.clients.transport.JsonEndpoint;
import co.elastic.clients.transport.TransportOptions;
import co.elastic.clients.util.ObjectBuilder;
import java.io.IOException;
import java.util.function.Function;
import javax.annotation.Nullable;

public class ElasticsearchInferenceClient
extends ApiClient<ElasticsearchTransport, ElasticsearchInferenceClient> {
    public ElasticsearchInferenceClient(ElasticsearchTransport transport) {
        super(transport, null);
    }

    public ElasticsearchInferenceClient(ElasticsearchTransport transport, @Nullable TransportOptions transportOptions) {
        super(transport, transportOptions);
    }

    @Override
    public ElasticsearchInferenceClient withTransportOptions(@Nullable TransportOptions transportOptions) {
        return new ElasticsearchInferenceClient((ElasticsearchTransport)this.transport, transportOptions);
    }

    public DeleteModelResponse deleteModel(DeleteModelRequest request) throws IOException, ElasticsearchException {
        JsonEndpoint endpoint = (JsonEndpoint)DeleteModelRequest._ENDPOINT;
        return (DeleteModelResponse)((ElasticsearchTransport)this.transport).performRequest(request, endpoint, this.transportOptions);
    }

    public final DeleteModelResponse deleteModel(Function<DeleteModelRequest.Builder, ObjectBuilder<DeleteModelRequest>> fn) throws IOException, ElasticsearchException {
        return this.deleteModel(fn.apply(new DeleteModelRequest.Builder()).build());
    }

    public GetModelResponse getModel(GetModelRequest request) throws IOException, ElasticsearchException {
        JsonEndpoint endpoint = (JsonEndpoint)GetModelRequest._ENDPOINT;
        return (GetModelResponse)((ElasticsearchTransport)this.transport).performRequest(request, endpoint, this.transportOptions);
    }

    public final GetModelResponse getModel(Function<GetModelRequest.Builder, ObjectBuilder<GetModelRequest>> fn) throws IOException, ElasticsearchException {
        return this.getModel(fn.apply(new GetModelRequest.Builder()).build());
    }

    public InferenceResponse inference(InferenceRequest request) throws IOException, ElasticsearchException {
        JsonEndpoint endpoint = (JsonEndpoint)InferenceRequest._ENDPOINT;
        return (InferenceResponse)((ElasticsearchTransport)this.transport).performRequest(request, endpoint, this.transportOptions);
    }

    public final InferenceResponse inference(Function<InferenceRequest.Builder, ObjectBuilder<InferenceRequest>> fn) throws IOException, ElasticsearchException {
        return this.inference(fn.apply(new InferenceRequest.Builder()).build());
    }

    public PutModelResponse putModel(PutModelRequest request) throws IOException, ElasticsearchException {
        JsonEndpoint endpoint = (JsonEndpoint)PutModelRequest._ENDPOINT;
        return (PutModelResponse)((ElasticsearchTransport)this.transport).performRequest(request, endpoint, this.transportOptions);
    }

    public final PutModelResponse putModel(Function<PutModelRequest.Builder, ObjectBuilder<PutModelRequest>> fn) throws IOException, ElasticsearchException {
        return this.putModel(fn.apply(new PutModelRequest.Builder()).build());
    }
}

