/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.nodes;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class Recording
implements JsonpSerializable {
    @Nullable
    private final String name;
    @Nullable
    private final Long cumulativeExecutionCount;
    @Nullable
    private final String cumulativeExecutionTime;
    @Nullable
    private final Long cumulativeExecutionTimeMillis;
    public static final JsonpDeserializer<Recording> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Recording::setupRecordingDeserializer);

    private Recording(Builder builder) {
        this.name = builder.name;
        this.cumulativeExecutionCount = builder.cumulativeExecutionCount;
        this.cumulativeExecutionTime = builder.cumulativeExecutionTime;
        this.cumulativeExecutionTimeMillis = builder.cumulativeExecutionTimeMillis;
    }

    public static Recording of(Function<Builder, ObjectBuilder<Recording>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String name() {
        return this.name;
    }

    @Nullable
    public final Long cumulativeExecutionCount() {
        return this.cumulativeExecutionCount;
    }

    @Nullable
    public final String cumulativeExecutionTime() {
        return this.cumulativeExecutionTime;
    }

    @Nullable
    public final Long cumulativeExecutionTimeMillis() {
        return this.cumulativeExecutionTimeMillis;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.name != null) {
            generator.writeKey("name");
            generator.write(this.name);
        }
        if (this.cumulativeExecutionCount != null) {
            generator.writeKey("cumulative_execution_count");
            generator.write(this.cumulativeExecutionCount.longValue());
        }
        if (this.cumulativeExecutionTime != null) {
            generator.writeKey("cumulative_execution_time");
            generator.write(this.cumulativeExecutionTime);
        }
        if (this.cumulativeExecutionTimeMillis != null) {
            generator.writeKey("cumulative_execution_time_millis");
            generator.write(this.cumulativeExecutionTimeMillis.longValue());
        }
    }

    protected static void setupRecordingDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::name, JsonpDeserializer.stringDeserializer(), "name");
        op.add(Builder::cumulativeExecutionCount, JsonpDeserializer.longDeserializer(), "cumulative_execution_count");
        op.add(Builder::cumulativeExecutionTime, JsonpDeserializer.stringDeserializer(), "cumulative_execution_time");
        op.add(Builder::cumulativeExecutionTimeMillis, JsonpDeserializer.longDeserializer(), "cumulative_execution_time_millis");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<Recording> {
        @Nullable
        private String name;
        @Nullable
        private Long cumulativeExecutionCount;
        @Nullable
        private String cumulativeExecutionTime;
        @Nullable
        private Long cumulativeExecutionTimeMillis;

        public final Builder name(@Nullable String value) {
            this.name = value;
            return this;
        }

        public final Builder cumulativeExecutionCount(@Nullable Long value) {
            this.cumulativeExecutionCount = value;
            return this;
        }

        public final Builder cumulativeExecutionTime(@Nullable String value) {
            this.cumulativeExecutionTime = value;
            return this;
        }

        public final Builder cumulativeExecutionTimeMillis(@Nullable Long value) {
            this.cumulativeExecutionTimeMillis = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public Recording build() {
            this._checkSingleUse();
            return new Recording(this);
        }
    }
}

