/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.elasticsearch._types.aggregations.Aggregate;
import co.elastic.clients.elasticsearch._types.aggregations.AggregateVariant;
import co.elastic.clients.elasticsearch._types.aggregations.DateHistogramBucket;
import co.elastic.clients.elasticsearch._types.aggregations.MultiBucketAggregateBase;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.DateTime;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class AutoDateHistogramAggregate
extends MultiBucketAggregateBase<DateHistogramBucket>
implements AggregateVariant {
    private final DateTime interval;
    public static final JsonpDeserializer<AutoDateHistogramAggregate> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, AutoDateHistogramAggregate::setupAutoDateHistogramAggregateDeserializer);

    private AutoDateHistogramAggregate(Builder builder) {
        super(builder);
        this.interval = ApiTypeHelper.requireNonNull(builder.interval, this, "interval");
    }

    public static AutoDateHistogramAggregate of(Function<Builder, ObjectBuilder<AutoDateHistogramAggregate>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Aggregate.Kind _aggregateKind() {
        return Aggregate.Kind.AutoDateHistogram;
    }

    public final DateTime interval() {
        return this.interval;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("interval");
        this.interval.serialize(generator, mapper);
    }

    protected static void setupAutoDateHistogramAggregateDeserializer(ObjectDeserializer<Builder> op) {
        MultiBucketAggregateBase.setupMultiBucketAggregateBaseDeserializer(op, DateHistogramBucket._DESERIALIZER);
        op.add(Builder::interval, DateTime._DESERIALIZER, "interval");
    }

    public static class Builder
    extends MultiBucketAggregateBase.AbstractBuilder<DateHistogramBucket, Builder>
    implements ObjectBuilder<AutoDateHistogramAggregate> {
        private DateTime interval;

        public final Builder interval(DateTime value) {
            this.interval = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public AutoDateHistogramAggregate build() {
            this._checkSingleUse();
            super.tBucketSerializer(null);
            return new AutoDateHistogramAggregate(this);
        }
    }
}

