/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.xpack.info;

import co.elastic.clients.elasticsearch.license.LicenseStatus;
import co.elastic.clients.elasticsearch.license.LicenseType;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.DateTime;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class MinimalLicenseInformation
implements JsonpSerializable {
    private final DateTime expiryDateInMillis;
    private final LicenseType mode;
    private final LicenseStatus status;
    private final LicenseType type;
    private final String uid;
    public static final JsonpDeserializer<MinimalLicenseInformation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, MinimalLicenseInformation::setupMinimalLicenseInformationDeserializer);

    private MinimalLicenseInformation(Builder builder) {
        this.expiryDateInMillis = ApiTypeHelper.requireNonNull(builder.expiryDateInMillis, this, "expiryDateInMillis");
        this.mode = ApiTypeHelper.requireNonNull(builder.mode, this, "mode");
        this.status = ApiTypeHelper.requireNonNull(builder.status, this, "status");
        this.type = ApiTypeHelper.requireNonNull(builder.type, this, "type");
        this.uid = ApiTypeHelper.requireNonNull(builder.uid, this, "uid");
    }

    public static MinimalLicenseInformation of(Function<Builder, ObjectBuilder<MinimalLicenseInformation>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final DateTime expiryDateInMillis() {
        return this.expiryDateInMillis;
    }

    public final LicenseType mode() {
        return this.mode;
    }

    public final LicenseStatus status() {
        return this.status;
    }

    public final LicenseType type() {
        return this.type;
    }

    public final String uid() {
        return this.uid;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("expiry_date_in_millis");
        this.expiryDateInMillis.serialize(generator, mapper);
        generator.writeKey("mode");
        this.mode.serialize(generator, mapper);
        generator.writeKey("status");
        this.status.serialize(generator, mapper);
        generator.writeKey("type");
        this.type.serialize(generator, mapper);
        generator.writeKey("uid");
        generator.write(this.uid);
    }

    protected static void setupMinimalLicenseInformationDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::expiryDateInMillis, DateTime._DESERIALIZER, "expiry_date_in_millis");
        op.add(Builder::mode, LicenseType._DESERIALIZER, "mode");
        op.add(Builder::status, LicenseStatus._DESERIALIZER, "status");
        op.add(Builder::type, LicenseType._DESERIALIZER, "type");
        op.add(Builder::uid, JsonpDeserializer.stringDeserializer(), "uid");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<MinimalLicenseInformation> {
        private DateTime expiryDateInMillis;
        private LicenseType mode;
        private LicenseStatus status;
        private LicenseType type;
        private String uid;

        public final Builder expiryDateInMillis(DateTime value) {
            this.expiryDateInMillis = value;
            return this;
        }

        public final Builder mode(LicenseType value) {
            this.mode = value;
            return this;
        }

        public final Builder status(LicenseStatus value) {
            this.status = value;
            return this;
        }

        public final Builder type(LicenseType value) {
            this.type = value;
            return this;
        }

        public final Builder uid(String value) {
            this.uid = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public MinimalLicenseInformation build() {
            this._checkSingleUse();
            return new MinimalLicenseInformation(this);
        }
    }
}

