/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.aggregations.InferenceConfig;
import co.elastic.clients.elasticsearch.ml.PutTrainedModelResponse;
import co.elastic.clients.elasticsearch.ml.TrainedModelType;
import co.elastic.clients.elasticsearch.ml.put_trained_model.Definition;
import co.elastic.clients.elasticsearch.ml.put_trained_model.Input;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class PutTrainedModelRequest
extends RequestBase
implements JsonpSerializable {
    @Nullable
    private final String compressedDefinition;
    @Nullable
    private final Boolean deferDefinitionDecompression;
    @Nullable
    private final Definition definition;
    @Nullable
    private final String description;
    private final InferenceConfig inferenceConfig;
    private final Input input;
    @Nullable
    private final JsonData metadata;
    private final String modelId;
    @Nullable
    private final Long modelSizeBytes;
    @Nullable
    private final TrainedModelType modelType;
    private final List<String> tags;
    public static final JsonpDeserializer<PutTrainedModelRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PutTrainedModelRequest::setupPutTrainedModelRequestDeserializer);
    public static final Endpoint<PutTrainedModelRequest, PutTrainedModelResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<PutTrainedModelRequest, PutTrainedModelResponse>("es/ml.put_trained_model", request -> "PUT", request -> {
        boolean _modelId = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_ml");
            buf.append("/trained_models");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.modelId, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.deferDefinitionDecompression != null) {
            params.put("defer_definition_decompression", String.valueOf(request.deferDefinitionDecompression));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, PutTrainedModelResponse._DESERIALIZER);

    private PutTrainedModelRequest(Builder builder) {
        this.compressedDefinition = builder.compressedDefinition;
        this.deferDefinitionDecompression = builder.deferDefinitionDecompression;
        this.definition = builder.definition;
        this.description = builder.description;
        this.inferenceConfig = ApiTypeHelper.requireNonNull(builder.inferenceConfig, this, "inferenceConfig");
        this.input = ApiTypeHelper.requireNonNull(builder.input, this, "input");
        this.metadata = builder.metadata;
        this.modelId = ApiTypeHelper.requireNonNull(builder.modelId, this, "modelId");
        this.modelSizeBytes = builder.modelSizeBytes;
        this.modelType = builder.modelType;
        this.tags = ApiTypeHelper.unmodifiable(builder.tags);
    }

    public static PutTrainedModelRequest of(Function<Builder, ObjectBuilder<PutTrainedModelRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String compressedDefinition() {
        return this.compressedDefinition;
    }

    @Nullable
    public final Boolean deferDefinitionDecompression() {
        return this.deferDefinitionDecompression;
    }

    @Nullable
    public final Definition definition() {
        return this.definition;
    }

    @Nullable
    public final String description() {
        return this.description;
    }

    public final InferenceConfig inferenceConfig() {
        return this.inferenceConfig;
    }

    public final Input input() {
        return this.input;
    }

    @Nullable
    public final JsonData metadata() {
        return this.metadata;
    }

    public final String modelId() {
        return this.modelId;
    }

    @Nullable
    public final Long modelSizeBytes() {
        return this.modelSizeBytes;
    }

    @Nullable
    public final TrainedModelType modelType() {
        return this.modelType;
    }

    public final List<String> tags() {
        return this.tags;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.compressedDefinition != null) {
            generator.writeKey("compressed_definition");
            generator.write(this.compressedDefinition);
        }
        if (this.definition != null) {
            generator.writeKey("definition");
            this.definition.serialize(generator, mapper);
        }
        if (this.description != null) {
            generator.writeKey("description");
            generator.write(this.description);
        }
        generator.writeKey("inference_config");
        this.inferenceConfig.serialize(generator, mapper);
        generator.writeKey("input");
        this.input.serialize(generator, mapper);
        if (this.metadata != null) {
            generator.writeKey("metadata");
            this.metadata.serialize(generator, mapper);
        }
        if (this.modelSizeBytes != null) {
            generator.writeKey("model_size_bytes");
            generator.write(this.modelSizeBytes.longValue());
        }
        if (this.modelType != null) {
            generator.writeKey("model_type");
            this.modelType.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.tags)) {
            generator.writeKey("tags");
            generator.writeStartArray();
            for (String item0 : this.tags) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
    }

    protected static void setupPutTrainedModelRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::compressedDefinition, JsonpDeserializer.stringDeserializer(), "compressed_definition");
        op.add(Builder::definition, Definition._DESERIALIZER, "definition");
        op.add(Builder::description, JsonpDeserializer.stringDeserializer(), "description");
        op.add(Builder::inferenceConfig, InferenceConfig._DESERIALIZER, "inference_config");
        op.add(Builder::input, Input._DESERIALIZER, "input");
        op.add(Builder::metadata, JsonData._DESERIALIZER, "metadata");
        op.add(Builder::modelSizeBytes, JsonpDeserializer.longDeserializer(), "model_size_bytes");
        op.add(Builder::modelType, TrainedModelType._DESERIALIZER, "model_type");
        op.add(Builder::tags, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "tags");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<PutTrainedModelRequest> {
        @Nullable
        private String compressedDefinition;
        @Nullable
        private Boolean deferDefinitionDecompression;
        @Nullable
        private Definition definition;
        @Nullable
        private String description;
        private InferenceConfig inferenceConfig;
        private Input input;
        @Nullable
        private JsonData metadata;
        private String modelId;
        @Nullable
        private Long modelSizeBytes;
        @Nullable
        private TrainedModelType modelType;
        @Nullable
        private List<String> tags;

        public final Builder compressedDefinition(@Nullable String value) {
            this.compressedDefinition = value;
            return this;
        }

        public final Builder deferDefinitionDecompression(@Nullable Boolean value) {
            this.deferDefinitionDecompression = value;
            return this;
        }

        public final Builder definition(@Nullable Definition value) {
            this.definition = value;
            return this;
        }

        public final Builder definition(Function<Definition.Builder, ObjectBuilder<Definition>> fn) {
            return this.definition(fn.apply(new Definition.Builder()).build());
        }

        public final Builder description(@Nullable String value) {
            this.description = value;
            return this;
        }

        public final Builder inferenceConfig(InferenceConfig value) {
            this.inferenceConfig = value;
            return this;
        }

        public final Builder inferenceConfig(Function<InferenceConfig.Builder, ObjectBuilder<InferenceConfig>> fn) {
            return this.inferenceConfig(fn.apply(new InferenceConfig.Builder()).build());
        }

        public final Builder input(Input value) {
            this.input = value;
            return this;
        }

        public final Builder input(Function<Input.Builder, ObjectBuilder<Input>> fn) {
            return this.input(fn.apply(new Input.Builder()).build());
        }

        public final Builder metadata(@Nullable JsonData value) {
            this.metadata = value;
            return this;
        }

        public final Builder modelId(String value) {
            this.modelId = value;
            return this;
        }

        public final Builder modelSizeBytes(@Nullable Long value) {
            this.modelSizeBytes = value;
            return this;
        }

        public final Builder modelType(@Nullable TrainedModelType value) {
            this.modelType = value;
            return this;
        }

        public final Builder tags(List<String> list) {
            this.tags = Builder._listAddAll(this.tags, list);
            return this;
        }

        public final Builder tags(String value, String ... values) {
            this.tags = Builder._listAdd(this.tags, value, values);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public PutTrainedModelRequest build() {
            this._checkSingleUse();
            return new PutTrainedModelRequest(this);
        }
    }
}

