/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core.bulk;

import co.elastic.clients.elasticsearch._types.ErrorCause;
import co.elastic.clients.elasticsearch._types.InlineGet;
import co.elastic.clients.elasticsearch._types.ShardStatistics;
import co.elastic.clients.elasticsearch.core.bulk.OperationType;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class BulkResponseItem
implements JsonpSerializable {
    private final OperationType operationType;
    @Nullable
    private final String id;
    private final String index;
    private final int status;
    @Nullable
    private final ErrorCause error;
    @Nullable
    private final Long primaryTerm;
    @Nullable
    private final String result;
    @Nullable
    private final Long seqNo;
    @Nullable
    private final ShardStatistics shards;
    @Nullable
    private final Long version;
    @Nullable
    private final Boolean forcedRefresh;
    @Nullable
    private final InlineGet<Map<String, JsonData>> get;
    public static final JsonpDeserializer<BulkResponseItem> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, BulkResponseItem::setupBulkResponseItemDeserializer);

    private BulkResponseItem(Builder builder) {
        this.operationType = ApiTypeHelper.requireNonNull(builder.operationType, this, "operationType");
        this.id = builder.id;
        this.index = ApiTypeHelper.requireNonNull(builder.index, this, "index");
        this.status = ApiTypeHelper.requireNonNull(builder.status, this, "status");
        this.error = builder.error;
        this.primaryTerm = builder.primaryTerm;
        this.result = builder.result;
        this.seqNo = builder.seqNo;
        this.shards = builder.shards;
        this.version = builder.version;
        this.forcedRefresh = builder.forcedRefresh;
        this.get = builder.get;
    }

    public static BulkResponseItem of(Function<Builder, ObjectBuilder<BulkResponseItem>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final OperationType operationType() {
        return this.operationType;
    }

    @Nullable
    public final String id() {
        return this.id;
    }

    public final String index() {
        return this.index;
    }

    public final int status() {
        return this.status;
    }

    @Nullable
    public final ErrorCause error() {
        return this.error;
    }

    @Nullable
    public final Long primaryTerm() {
        return this.primaryTerm;
    }

    @Nullable
    public final String result() {
        return this.result;
    }

    @Nullable
    public final Long seqNo() {
        return this.seqNo;
    }

    @Nullable
    public final ShardStatistics shards() {
        return this.shards;
    }

    @Nullable
    public final Long version() {
        return this.version;
    }

    @Nullable
    public final Boolean forcedRefresh() {
        return this.forcedRefresh;
    }

    @Nullable
    public final InlineGet<Map<String, JsonData>> get() {
        return this.get;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject(this.operationType.jsonValue());
        if (this.id != null) {
            generator.writeKey("_id");
            generator.write(this.id);
        }
        generator.writeKey("_index");
        generator.write(this.index);
        generator.writeKey("status");
        generator.write(this.status);
        if (this.error != null) {
            generator.writeKey("error");
            this.error.serialize(generator, mapper);
        }
        if (this.primaryTerm != null) {
            generator.writeKey("_primary_term");
            generator.write(this.primaryTerm.longValue());
        }
        if (this.result != null) {
            generator.writeKey("result");
            generator.write(this.result);
        }
        if (this.seqNo != null) {
            generator.writeKey("_seq_no");
            generator.write(this.seqNo.longValue());
        }
        if (this.shards != null) {
            generator.writeKey("_shards");
            this.shards.serialize(generator, mapper);
        }
        if (this.version != null) {
            generator.writeKey("_version");
            generator.write(this.version.longValue());
        }
        if (this.forcedRefresh != null) {
            generator.writeKey("forced_refresh");
            generator.write(this.forcedRefresh.booleanValue());
        }
        if (this.get != null) {
            generator.writeKey("get");
            this.get.serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    protected static void setupBulkResponseItemDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::id, JsonpDeserializer.stringDeserializer(), "_id");
        op.add(Builder::index, JsonpDeserializer.stringDeserializer(), "_index");
        op.add(Builder::status, JsonpDeserializer.integerDeserializer(), "status");
        op.add(Builder::error, ErrorCause._DESERIALIZER, "error");
        op.add(Builder::primaryTerm, JsonpDeserializer.longDeserializer(), "_primary_term");
        op.add(Builder::result, JsonpDeserializer.stringDeserializer(), "result");
        op.add(Builder::seqNo, JsonpDeserializer.longDeserializer(), "_seq_no");
        op.add(Builder::shards, ShardStatistics._DESERIALIZER, "_shards");
        op.add(Builder::version, JsonpDeserializer.longDeserializer(), "_version");
        op.add(Builder::forcedRefresh, JsonpDeserializer.booleanDeserializer(), "forced_refresh");
        op.add(Builder::get, InlineGet.createInlineGetDeserializer(JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER)), "get");
        op.setKey(Builder::operationType, OperationType._DESERIALIZER);
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<BulkResponseItem> {
        private OperationType operationType;
        @Nullable
        private String id;
        private String index;
        private Integer status;
        @Nullable
        private ErrorCause error;
        @Nullable
        private Long primaryTerm;
        @Nullable
        private String result;
        @Nullable
        private Long seqNo;
        @Nullable
        private ShardStatistics shards;
        @Nullable
        private Long version;
        @Nullable
        private Boolean forcedRefresh;
        @Nullable
        private InlineGet<Map<String, JsonData>> get;

        public final Builder operationType(OperationType value) {
            this.operationType = value;
            return this;
        }

        public final Builder id(@Nullable String value) {
            this.id = value;
            return this;
        }

        public final Builder index(String value) {
            this.index = value;
            return this;
        }

        public final Builder status(int value) {
            this.status = value;
            return this;
        }

        public final Builder error(@Nullable ErrorCause value) {
            this.error = value;
            return this;
        }

        public final Builder error(Function<ErrorCause.Builder, ObjectBuilder<ErrorCause>> fn) {
            return this.error(fn.apply(new ErrorCause.Builder()).build());
        }

        public final Builder primaryTerm(@Nullable Long value) {
            this.primaryTerm = value;
            return this;
        }

        public final Builder result(@Nullable String value) {
            this.result = value;
            return this;
        }

        public final Builder seqNo(@Nullable Long value) {
            this.seqNo = value;
            return this;
        }

        public final Builder shards(@Nullable ShardStatistics value) {
            this.shards = value;
            return this;
        }

        public final Builder shards(Function<ShardStatistics.Builder, ObjectBuilder<ShardStatistics>> fn) {
            return this.shards(fn.apply(new ShardStatistics.Builder()).build());
        }

        public final Builder version(@Nullable Long value) {
            this.version = value;
            return this;
        }

        public final Builder forcedRefresh(@Nullable Boolean value) {
            this.forcedRefresh = value;
            return this;
        }

        public final Builder get(@Nullable InlineGet<Map<String, JsonData>> value) {
            this.get = value;
            return this;
        }

        public final Builder get(Function<InlineGet.Builder<Map<String, JsonData>>, ObjectBuilder<InlineGet<Map<String, JsonData>>>> fn) {
            return this.get(fn.apply(new InlineGet.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public BulkResponseItem build() {
            this._checkSingleUse();
            return new BulkResponseItem(this);
        }
    }
}

