/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core;

import co.elastic.clients.elasticsearch.core.termvectors.TermVector;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class TermvectorsResponse
implements JsonpSerializable {
    private final boolean found;
    private final String id;
    private final String index;
    private final Map<String, TermVector> termVectors;
    private final long took;
    private final long version;
    public static final JsonpDeserializer<TermvectorsResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, TermvectorsResponse::setupTermvectorsResponseDeserializer);

    private TermvectorsResponse(Builder builder) {
        this.found = ApiTypeHelper.requireNonNull(builder.found, this, "found");
        this.id = ApiTypeHelper.requireNonNull(builder.id, this, "id");
        this.index = ApiTypeHelper.requireNonNull(builder.index, this, "index");
        this.termVectors = ApiTypeHelper.unmodifiable(builder.termVectors);
        this.took = ApiTypeHelper.requireNonNull(builder.took, this, "took");
        this.version = ApiTypeHelper.requireNonNull(builder.version, this, "version");
    }

    public static TermvectorsResponse of(Function<Builder, ObjectBuilder<TermvectorsResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final boolean found() {
        return this.found;
    }

    public final String id() {
        return this.id;
    }

    public final String index() {
        return this.index;
    }

    public final Map<String, TermVector> termVectors() {
        return this.termVectors;
    }

    public final long took() {
        return this.took;
    }

    public final long version() {
        return this.version;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("found");
        generator.write(this.found);
        generator.writeKey("_id");
        generator.write(this.id);
        generator.writeKey("_index");
        generator.write(this.index);
        if (ApiTypeHelper.isDefined(this.termVectors)) {
            generator.writeKey("term_vectors");
            generator.writeStartObject();
            for (Map.Entry<String, TermVector> item0 : this.termVectors.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        generator.writeKey("took");
        generator.write(this.took);
        generator.writeKey("_version");
        generator.write(this.version);
    }

    protected static void setupTermvectorsResponseDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::found, JsonpDeserializer.booleanDeserializer(), "found");
        op.add(Builder::id, JsonpDeserializer.stringDeserializer(), "_id");
        op.add(Builder::index, JsonpDeserializer.stringDeserializer(), "_index");
        op.add(Builder::termVectors, JsonpDeserializer.stringMapDeserializer(TermVector._DESERIALIZER), "term_vectors");
        op.add(Builder::took, JsonpDeserializer.longDeserializer(), "took");
        op.add(Builder::version, JsonpDeserializer.longDeserializer(), "_version");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<TermvectorsResponse> {
        private Boolean found;
        private String id;
        private String index;
        @Nullable
        private Map<String, TermVector> termVectors;
        private Long took;
        private Long version;

        public final Builder found(boolean value) {
            this.found = value;
            return this;
        }

        public final Builder id(String value) {
            this.id = value;
            return this;
        }

        public final Builder index(String value) {
            this.index = value;
            return this;
        }

        public final Builder termVectors(Map<String, TermVector> map) {
            this.termVectors = Builder._mapPutAll(this.termVectors, map);
            return this;
        }

        public final Builder termVectors(String key, TermVector value) {
            this.termVectors = Builder._mapPut(this.termVectors, key, value);
            return this;
        }

        public final Builder termVectors(String key, Function<TermVector.Builder, ObjectBuilder<TermVector>> fn) {
            return this.termVectors(key, fn.apply(new TermVector.Builder()).build());
        }

        public final Builder took(long value) {
            this.took = value;
            return this;
        }

        public final Builder version(long value) {
            this.version = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public TermvectorsResponse build() {
            this._checkSingleUse();
            return new TermvectorsResponse(this);
        }
    }
}

