/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.xpack.usage;

import co.elastic.clients.elasticsearch.xpack.usage.MlInferenceDeployments;
import co.elastic.clients.elasticsearch.xpack.usage.MlInferenceIngestProcessor;
import co.elastic.clients.elasticsearch.xpack.usage.MlInferenceTrainedModels;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class MlInference
implements JsonpSerializable {
    private final Map<String, MlInferenceIngestProcessor> ingestProcessors;
    private final MlInferenceTrainedModels trainedModels;
    @Nullable
    private final MlInferenceDeployments deployments;
    public static final JsonpDeserializer<MlInference> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, MlInference::setupMlInferenceDeserializer);

    private MlInference(Builder builder) {
        this.ingestProcessors = ApiTypeHelper.unmodifiableRequired(builder.ingestProcessors, (Object)this, "ingestProcessors");
        this.trainedModels = ApiTypeHelper.requireNonNull(builder.trainedModels, this, "trainedModels");
        this.deployments = builder.deployments;
    }

    public static MlInference of(Function<Builder, ObjectBuilder<MlInference>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final Map<String, MlInferenceIngestProcessor> ingestProcessors() {
        return this.ingestProcessors;
    }

    public final MlInferenceTrainedModels trainedModels() {
        return this.trainedModels;
    }

    @Nullable
    public final MlInferenceDeployments deployments() {
        return this.deployments;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.ingestProcessors)) {
            generator.writeKey("ingest_processors");
            generator.writeStartObject();
            for (Map.Entry<String, MlInferenceIngestProcessor> item0 : this.ingestProcessors.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        generator.writeKey("trained_models");
        this.trainedModels.serialize(generator, mapper);
        if (this.deployments != null) {
            generator.writeKey("deployments");
            this.deployments.serialize(generator, mapper);
        }
    }

    protected static void setupMlInferenceDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::ingestProcessors, JsonpDeserializer.stringMapDeserializer(MlInferenceIngestProcessor._DESERIALIZER), "ingest_processors");
        op.add(Builder::trainedModels, MlInferenceTrainedModels._DESERIALIZER, "trained_models");
        op.add(Builder::deployments, MlInferenceDeployments._DESERIALIZER, "deployments");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<MlInference> {
        private Map<String, MlInferenceIngestProcessor> ingestProcessors;
        private MlInferenceTrainedModels trainedModels;
        @Nullable
        private MlInferenceDeployments deployments;

        public final Builder ingestProcessors(Map<String, MlInferenceIngestProcessor> map) {
            this.ingestProcessors = Builder._mapPutAll(this.ingestProcessors, map);
            return this;
        }

        public final Builder ingestProcessors(String key, MlInferenceIngestProcessor value) {
            this.ingestProcessors = Builder._mapPut(this.ingestProcessors, key, value);
            return this;
        }

        public final Builder ingestProcessors(String key, Function<MlInferenceIngestProcessor.Builder, ObjectBuilder<MlInferenceIngestProcessor>> fn) {
            return this.ingestProcessors(key, fn.apply(new MlInferenceIngestProcessor.Builder()).build());
        }

        public final Builder trainedModels(MlInferenceTrainedModels value) {
            this.trainedModels = value;
            return this;
        }

        public final Builder trainedModels(Function<MlInferenceTrainedModels.Builder, ObjectBuilder<MlInferenceTrainedModels>> fn) {
            return this.trainedModels(fn.apply(new MlInferenceTrainedModels.Builder()).build());
        }

        public final Builder deployments(@Nullable MlInferenceDeployments value) {
            this.deployments = value;
            return this;
        }

        public final Builder deployments(Function<MlInferenceDeployments.Builder, ObjectBuilder<MlInferenceDeployments>> fn) {
            return this.deployments(fn.apply(new MlInferenceDeployments.Builder()).build());
        }

        @Override
        public MlInference build() {
            this._checkSingleUse();
            return new MlInference(this);
        }
    }
}

