/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.sql;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch.sql.QueryResponse;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class QueryRequest
extends RequestBase
implements JsonpSerializable {
    @Nullable
    private final Boolean columnar;
    @Nullable
    private final String cursor;
    @Nullable
    private final Integer fetchSize;
    @Nullable
    private final Boolean fieldMultiValueLeniency;
    @Nullable
    private final Query filter;
    @Nullable
    private final String format;
    @Nullable
    private final Time pageTimeout;
    @Nullable
    private final String query;
    @Nullable
    private final Time requestTimeout;
    @Nullable
    private final String timeZone;
    public static final JsonpDeserializer<QueryRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, QueryRequest::setupQueryRequestDeserializer);
    public static final Endpoint<QueryRequest, QueryResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<QueryRequest, QueryResponse>("es/sql.query", request -> "POST", request -> "/_sql", request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.format != null) {
            params.put("format", request.format);
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, QueryResponse._DESERIALIZER);

    private QueryRequest(Builder builder) {
        this.columnar = builder.columnar;
        this.cursor = builder.cursor;
        this.fetchSize = builder.fetchSize;
        this.fieldMultiValueLeniency = builder.fieldMultiValueLeniency;
        this.filter = builder.filter;
        this.format = builder.format;
        this.pageTimeout = builder.pageTimeout;
        this.query = builder.query;
        this.requestTimeout = builder.requestTimeout;
        this.timeZone = builder.timeZone;
    }

    public static QueryRequest of(Function<Builder, ObjectBuilder<QueryRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Boolean columnar() {
        return this.columnar;
    }

    @Nullable
    public final String cursor() {
        return this.cursor;
    }

    @Nullable
    public final Integer fetchSize() {
        return this.fetchSize;
    }

    @Nullable
    public final Boolean fieldMultiValueLeniency() {
        return this.fieldMultiValueLeniency;
    }

    @Nullable
    public final Query filter() {
        return this.filter;
    }

    @Nullable
    public final String format() {
        return this.format;
    }

    @Nullable
    public final Time pageTimeout() {
        return this.pageTimeout;
    }

    @Nullable
    public final String query() {
        return this.query;
    }

    @Nullable
    public final Time requestTimeout() {
        return this.requestTimeout;
    }

    @Nullable
    public final String timeZone() {
        return this.timeZone;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.columnar != null) {
            generator.writeKey("columnar");
            generator.write(this.columnar.booleanValue());
        }
        if (this.cursor != null) {
            generator.writeKey("cursor");
            generator.write(this.cursor);
        }
        if (this.fetchSize != null) {
            generator.writeKey("fetch_size");
            generator.write(this.fetchSize.intValue());
        }
        if (this.fieldMultiValueLeniency != null) {
            generator.writeKey("field_multi_value_leniency");
            generator.write(this.fieldMultiValueLeniency.booleanValue());
        }
        if (this.filter != null) {
            generator.writeKey("filter");
            this.filter.serialize(generator, mapper);
        }
        if (this.pageTimeout != null) {
            generator.writeKey("page_timeout");
            this.pageTimeout.serialize(generator, mapper);
        }
        if (this.query != null) {
            generator.writeKey("query");
            generator.write(this.query);
        }
        if (this.requestTimeout != null) {
            generator.writeKey("request_timeout");
            this.requestTimeout.serialize(generator, mapper);
        }
        if (this.timeZone != null) {
            generator.writeKey("time_zone");
            generator.write(this.timeZone);
        }
    }

    protected static void setupQueryRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::columnar, JsonpDeserializer.booleanDeserializer(), "columnar");
        op.add(Builder::cursor, JsonpDeserializer.stringDeserializer(), "cursor");
        op.add(Builder::fetchSize, JsonpDeserializer.integerDeserializer(), "fetch_size");
        op.add(Builder::fieldMultiValueLeniency, JsonpDeserializer.booleanDeserializer(), "field_multi_value_leniency");
        op.add(Builder::filter, Query._DESERIALIZER, "filter");
        op.add(Builder::pageTimeout, Time._DESERIALIZER, "page_timeout");
        op.add(Builder::query, JsonpDeserializer.stringDeserializer(), "query");
        op.add(Builder::requestTimeout, Time._DESERIALIZER, "request_timeout");
        op.add(Builder::timeZone, JsonpDeserializer.stringDeserializer(), "time_zone");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<QueryRequest> {
        @Nullable
        private Boolean columnar;
        @Nullable
        private String cursor;
        @Nullable
        private Integer fetchSize;
        @Nullable
        private Boolean fieldMultiValueLeniency;
        @Nullable
        private Query filter;
        @Nullable
        private String format;
        @Nullable
        private Time pageTimeout;
        @Nullable
        private String query;
        @Nullable
        private Time requestTimeout;
        @Nullable
        private String timeZone;

        public final Builder columnar(@Nullable Boolean value) {
            this.columnar = value;
            return this;
        }

        public final Builder cursor(@Nullable String value) {
            this.cursor = value;
            return this;
        }

        public final Builder fetchSize(@Nullable Integer value) {
            this.fetchSize = value;
            return this;
        }

        public final Builder fieldMultiValueLeniency(@Nullable Boolean value) {
            this.fieldMultiValueLeniency = value;
            return this;
        }

        public final Builder filter(@Nullable Query value) {
            this.filter = value;
            return this;
        }

        public final Builder filter(Function<Query.Builder, ObjectBuilder<Query>> fn) {
            return this.filter(fn.apply(new Query.Builder()).build());
        }

        public final Builder format(@Nullable String value) {
            this.format = value;
            return this;
        }

        public final Builder pageTimeout(@Nullable Time value) {
            this.pageTimeout = value;
            return this;
        }

        public final Builder pageTimeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.pageTimeout(fn.apply(new Time.Builder()).build());
        }

        public final Builder query(@Nullable String value) {
            this.query = value;
            return this;
        }

        public final Builder requestTimeout(@Nullable Time value) {
            this.requestTimeout = value;
            return this;
        }

        public final Builder requestTimeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.requestTimeout(fn.apply(new Time.Builder()).build());
        }

        public final Builder timeZone(@Nullable String value) {
            this.timeZone = value;
            return this;
        }

        @Override
        public QueryRequest build() {
            this._checkSingleUse();
            return new QueryRequest(this);
        }
    }
}

