/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.security;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class SamlAuthenticateResponse
implements JsonpSerializable {
    private final String accessToken;
    private final String username;
    private final int expiresIn;
    private final String refreshToken;
    private final String realm;
    public static final JsonpDeserializer<SamlAuthenticateResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SamlAuthenticateResponse::setupSamlAuthenticateResponseDeserializer);

    private SamlAuthenticateResponse(Builder builder) {
        this.accessToken = ApiTypeHelper.requireNonNull(builder.accessToken, this, "accessToken");
        this.username = ApiTypeHelper.requireNonNull(builder.username, this, "username");
        this.expiresIn = ApiTypeHelper.requireNonNull(builder.expiresIn, this, "expiresIn");
        this.refreshToken = ApiTypeHelper.requireNonNull(builder.refreshToken, this, "refreshToken");
        this.realm = ApiTypeHelper.requireNonNull(builder.realm, this, "realm");
    }

    public static SamlAuthenticateResponse of(Function<Builder, ObjectBuilder<SamlAuthenticateResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String accessToken() {
        return this.accessToken;
    }

    public final String username() {
        return this.username;
    }

    public final int expiresIn() {
        return this.expiresIn;
    }

    public final String refreshToken() {
        return this.refreshToken;
    }

    public final String realm() {
        return this.realm;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("access_token");
        generator.write(this.accessToken);
        generator.writeKey("username");
        generator.write(this.username);
        generator.writeKey("expires_in");
        generator.write(this.expiresIn);
        generator.writeKey("refresh_token");
        generator.write(this.refreshToken);
        generator.writeKey("realm");
        generator.write(this.realm);
    }

    protected static void setupSamlAuthenticateResponseDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::accessToken, JsonpDeserializer.stringDeserializer(), "access_token");
        op.add(Builder::username, JsonpDeserializer.stringDeserializer(), "username");
        op.add(Builder::expiresIn, JsonpDeserializer.integerDeserializer(), "expires_in");
        op.add(Builder::refreshToken, JsonpDeserializer.stringDeserializer(), "refresh_token");
        op.add(Builder::realm, JsonpDeserializer.stringDeserializer(), "realm");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<SamlAuthenticateResponse> {
        private String accessToken;
        private String username;
        private Integer expiresIn;
        private String refreshToken;
        private String realm;

        public final Builder accessToken(String value) {
            this.accessToken = value;
            return this;
        }

        public final Builder username(String value) {
            this.username = value;
            return this;
        }

        public final Builder expiresIn(int value) {
            this.expiresIn = value;
            return this;
        }

        public final Builder refreshToken(String value) {
            this.refreshToken = value;
            return this;
        }

        public final Builder realm(String value) {
            this.realm = value;
            return this;
        }

        @Override
        public SamlAuthenticateResponse build() {
            this._checkSingleUse();
            return new SamlAuthenticateResponse(this);
        }
    }
}

